<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">

    <style>
        /* Vision & Mission Styles */
        .vm-section {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 80px 0;
            position: relative;
            overflow: hidden;
        }

        .vm-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .vm-header h2 {
            font-family: 'Cinzel', serif;
            font-size: 2.5rem;
            color: #1b7e57;
            margin-bottom: 15px;
            font-weight: 700;
        }

        .vm-header .subtitle {
            font-size: 1.1rem;
            color: #666;
            font-weight: 500;
        }

        /* Vision & Mission Cards */
        .vm-card {
            background: #fff;
            border-radius: 20px;
            padding: 50px 40px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            position: relative;
            transition: all 0.4s ease;
            border: 2px solid transparent;
        }

        .vm-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 60px rgba(27, 126, 87, 0.15);
            border-color: #1b7e57;
        }

        .vm-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #1b7e57, #2d9f6f);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 40px;
            color: #fff;
        }

        .vm-card h3 {
            font-family: 'Cinzel', serif;
            color: #1b7e57;
            font-size: 2rem;
            margin-bottom: 25px;
            text-align: center;
            font-weight: 700;
        }

        .vm-content {
            text-align: center;
            line-height: 1.8;
            color: #555;
            font-size: 1rem;
            min-height: 150px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .vm-content p {
            margin: 0;
        }

        /* Divider */
        .vm-divider {
            width: 60px;
            height: 4px;
            background: linear-gradient(90deg, transparent, #1b7e57, transparent);
            margin: 0 auto 15px;
        }

        /* Values Section */
        .values-section {
            background: #fff;
            padding: 60px 0;
            margin-top: 60px;
        }

        .values-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }

        .value-item {
            text-align: center;
            padding: 25px;
            background: #f8f9fa;
            border-radius: 15px;
            transition: all 0.3s ease;
        }

        .value-item:hover {
            background: #1b7e57;
            color: #fff;
            transform: scale(1.05);
        }

        .value-item i {
            font-size: 35px;
            color: #1b7e57;
            margin-bottom: 15px;
            display: block;
        }

        .value-item:hover i {
            color: #fff;
        }

        .value-item h4 {
            font-family: 'Cinzel', serif;
            color: #1b7e57;
            font-size: 1.3rem;
            margin-bottom: 10px;
            font-weight: 700;
        }

        .value-item:hover h4 {
            color: #fff;
        }

        .value-item p {
            font-size: 0.95rem;
            color: #666;
            margin: 0;
        }

        .value-item:hover p {
            color: #f0f0f0;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .vm-section {
                padding: 50px 0;
            }

            .vm-header h2 {
                font-size: 2rem;
            }

            .vm-card {
                padding: 35px 25px;
                margin-bottom: 30px;
            }

            .vm-card h3 {
                font-size: 1.6rem;
            }

            .vm-icon {
                width: 70px;
                height: 70px;
                font-size: 32px;
            }

            .values-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Placeholder text styles */
        .placeholder-text {
            color: #999;
            font-style: italic;
        }

        .edit-hint {
            display: block;
            font-size: 0.85rem;
            color: #999;
            margin-top: 10px;
            font-style: italic;
        }
    </style>
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
               <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link">Tentang Kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle active" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 shadow-sm m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item">Profil Guru</a>
                            <a href="galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item">Infaq</a>
                            <a href="visi-misi.php" class="dropdown-item active">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Visi & Misi</h1>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Testimonial Start -->
        <div class="vm-section">
            <div class="container">
                <!-- Header -->
                <div class="vm-header wow fadeInUp" data-wow-delay="0.1s">
                    <h2>Visi & Misi Kami</h2>
                    <p class="subtitle">Komitmen Pondok Tahfidz Qur'an Al-Luqman untuk Masa Depan</p>
                </div>

                <!-- Vision & Mission Cards -->
                <div class="row g-4">
                    <!-- VISI Card -->
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.2s">
                        <div class="vm-card">
                            <div class="vm-icon">
                                <i class="fas fa-binoculars"></i>
                            </div>
                            <div class="vm-divider"></div>
                            <h3>VISI</h3>
                            <div class="vm-content">
                               <p class="vm-header wow fadeInUp" data-wow-delay="0.1s">
                                    ❀ Mencetak generasi penghafal Al-Qur’an yang berjiwa dan berakhlaq Qur’an.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- MISI Card -->
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="vm-card">
                            <div class="vm-icon">
                                <i class="fas fa-tasks"></i>
                            </div>
                            <div class="vm-divider"></div>
                            <h3>MISI</h3>
                            <div class="vm-content">
                                <p class="vm-header wow fadeInUp" data-wow-delay="0.1s">
                                    ❀ Menerapkan pendidikan karakter yang baik (berdasarkan Al-Quran dan Al-Hadist).<br>
                                    ❀ Membimbing untuk selalu berdoa, menghafal, muroja’ah dan belajar, serta menerapkannya dalam kehidupan sehari-hari.<br>
                                    ❀ Mendidik Hafidz/Hafidzah sejak usia dini.<br>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Values Section -->
        <div class="values-section">
            <div class="container">
                <div class="vm-header wow fadeInUp" data-wow-delay="0.1s">
                    <h2>Nilai-Nilai Kami</h2>
                    <p class="subtitle">Prinsip Utama yang Kami Pegang Teguh</p>
                </div>

                <div class="values-grid">
                    <!-- Value 1 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.2s">
                        <i class="fas fa-moon"></i>
                        <h4>Islami</h4>
                        <p>Berbasis nilai-nilai Al-Quran dan Hadis sebagai fondasi pembelajaran</p>
                    </div>

                    <!-- Value 2 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.3s">
                        <i class="fas fa-handshake"></i>
                        <h4>Integritas</h4>
                        <p>Menjunjung tinggi kejujuran, kepercayaan, dan tanggung jawab</p>
                    </div>

                    <!-- Value 3 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.4s">
                        <i class="fas fa-users"></i>
                        <h4>Kolaborasi</h4>
                        <p>Bekerja sama dengan semua pihak untuk mencapai tujuan bersama</p>
                    </div>

                    <!-- Value 4 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.5s">
                        <i class="fas fa-lightbulb"></i>
                        <h4>Inovasi</h4>
                        <p>Terus berkembang dan beradaptasi dengan perubahan zaman</p>
                    </div>

                    <!-- Value 5 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.6s">
                        <i class="fas fa-heart"></i>
                        <h4>Dedikasi</h4>
                        <p>Komitmen penuh dalam membimbing dan mendidik santri dengan sepenuh hati</p>
                    </div>

                    <!-- Value 6 -->
                    <div class="value-item wow fadeInUp" data-wow-delay="0.7s">
                        <i class="fas fa-star"></i>
                        <h4>Keunggulan</h4>
                        <p>Selalu berusaha memberikan yang terbaik dalam setiap aspek pendidikan</p>
                    </div>
                </div>
            </div>
        </div>
        <!-- Testimonial End -->



        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>