<?php
include "config/koneksi.php";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">

    <style>
        /* Program Section */
        .program-section {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 80px 0;
            position: relative;
        }

        .program-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .program-header h2 {
            font-family: 'Cinzel', serif;
            font-size: 2.5rem;
            color: #1b7e57;
            margin-bottom: 15px;
            font-weight: 700;
        }

        .program-header p {
            font-size: 1.1rem;
            color: #666;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Program Card */
        .program-card {
            background: #fff;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            transition: all 0.4s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .program-card:hover {
            transform: translateY(-12px);
            box-shadow: 0 20px 60px rgba(27, 126, 87, 0.2);
        }

        /* Program Image Container */
        .program-img-container {
            position: relative;
            width: 100%;
            height: 280px;
            overflow: hidden;
            background: linear-gradient(135deg, #1b7e57, #2d9f6f);
        }

        .program-img-container img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.4s ease;
        }

        .program-card:hover .program-img-container img {
            transform: scale(1.08);
        }

        /* Badge Nomor Program */
        .program-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            background: #1b7e57;
            color: #fff;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.2rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        /* Program Content */
        .program-content {
            padding: 35px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .program-content h3 {
            font-family: 'Cinzel', serif;
            color: #1b7e57;
            font-size: 1.6rem;
            margin-bottom: 15px;
            font-weight: 700;
        }

        /* Schedule Row */
        .schedule-row {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            padding: 12px;
            background: #f8f9fa;
            border-left: 4px solid #1b7e57;
            border-radius: 6px;
        }

        .schedule-row i {
            color: #1b7e57;
            font-size: 1.3rem;
            margin-right: 15px;
            width: 30px;
            text-align: center;
        }

        .schedule-time {
            font-weight: 700;
            color: #1b7e57;
            font-size: 1.05rem;
        }

        .schedule-info {
            font-size: 0.95rem;
            color: #666;
            margin-left: auto;
        }

        /* Description */
        .program-description {
            color: #555;
            line-height: 1.7;
            font-size: 0.95rem;
            margin-bottom: 20px;
            flex-grow: 1;
        }

        .program-description strong {
            color: #1b7e57;
        }

        /* Action Button */
        .program-btn {
            background: linear-gradient(135deg, #1b7e57, #2d9f6f);
            color: #fff;
            border: none;
            padding: 12px 25px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s ease;
            align-self: flex-start;
            text-decoration: none;
            display: inline-block;
        }

        .program-btn:hover {
            background: linear-gradient(135deg, #145f42, #1b7e57);
            transform: translateX(5px);
            color: #fff;
        }

        /* Highlight Info Box */
        .program-highlight {
            background: #e8f5e9;
            border-left: 4px solid #1b7e57;
            padding: 12px 15px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-size: 0.9rem;
            color: #1b7e57;
            font-weight: 600;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .program-section {
                padding: 50px 0;
            }

            .program-header h2 {
                font-size: 2rem;
            }

            .program-img-container {
                height: 220px;
            }

            .program-content {
                padding: 25px;
            }

            .program-content h3 {
                font-size: 1.4rem;
            }

            .schedule-row {
                padding: 10px;
            }
        }

        /* Grid Layout */
        .programs-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }

        @media (max-width: 992px) {
            .programs-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 576px) {
            .programs-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
               <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link">Tentang Kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle active" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item">Profil Guru</a>
                            <a href="galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item">Infaq</a>
                            <a href="visi-misi.php" class="dropdown-item">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item active">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Program</h1>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Program Start -->
        <div class="program-section">
            <div class="container">
                <!-- Header -->
                <div class="program-header wow fadeInUp" data-wow-delay="0.1s">
                    <h2>Program Pembelajaran</h2>
                    <p>Berbagai program pendidikan Al-Qur'an yang dirancang untuk semua tingkat usia dengan metode pembelajaran yang komprehensif dan terstruktur</p>
                </div>

                <!-- Program Cards Grid -->
<div class="programs-grid">
<?php
$query = mysqli_query($conn, "
    SELECT * FROM program
    WHERE status = 'aktif'
    ORDER BY urutan ASC
");

$delay = 0.05;

while ($row = mysqli_fetch_assoc($query)) {
?>
    <div class="program-card wow fadeInUp" data-wow-delay="<?= $delay ?>s">
        <div class="program-img-container">
   <img src="<?= htmlspecialchars($row['gambar']); ?>">
     alt="<?= htmlspecialchars($row['judul']); ?>">


            <span class="program-badge"><?= htmlspecialchars($row['urutan']); ?></span>
        </div>

        <div class="program-content">
            <h3><?= htmlspecialchars($row['judul']); ?></h3>

            <?php if(!empty($row['highlight'])) { ?>
            <div class="program-highlight">
                <?= htmlspecialchars($row['highlight']); ?>
            </div>
            <?php } ?>

            <div class="schedule-row">
                <i class="fas fa-clock"></i>
                <span class="schedule-time">
                    <?= substr($row['jam_mulai'],0,5); ?> - <?= substr($row['jam_selesai'],0,5); ?>
                </span>
                <span class="schedule-info">
                    <?= htmlspecialchars($row['keterangan_waktu']); ?>
                </span>
            </div>

            <div class="program-description">
                <?= $row['deskripsi']; ?>
            </div>


            <?php if(!empty($row['link_daftar'])) { ?>
            <a href="<?= htmlspecialchars($row['link_daftar']); ?>" class="program-btn">
                <i class="fas fa-arrow-right me-2"></i> Daftar Sekarang
            </a>
            <?php } ?>
        </div>
    </div>
<?php
    $delay += 0.1;
}
?>
</div>


                </div>
            </div>
        </div>
        <!-- Program End -->



        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>