<?php
include "config/koneksi.php";
$queryGuru = mysqli_query($conn, "SELECT * FROM guru ORDER BY id_guru ASC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
                <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link">Tentang Kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle active" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 shadow-sm m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item active">Profil Guru</a>
                            <a href="galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item">Infaq</a>
                            <a href="visi-misi.php" class="dropdown-item">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Profil Guru</h1>
            </div>
        </div>
        <!-- Page Header End -->


<!-- Team Start -->
<div class="container-xxl py-5">
    <div class="container">
        <div class="text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
            <h1 class="mb-3">Profil Guru</h1>
            <p>Ini Adalah Beberapa Profil Guru Dari Pondok Kami</p>
        </div>

        <div class="row g-4">
            <?php while ($guru = mysqli_fetch_assoc($queryGuru)) { ?>
                <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                    <div class="team-item position-relative text-center">

                        <img class="img-fluid rounded-circle w-75 mb-3"
                             src="img/<?= htmlspecialchars($guru['foto']); ?>"
                             alt="<?= htmlspecialchars($guru['nama_guru']); ?>">

                        <div class="team-text">
                            <h3><?= htmlspecialchars($guru['nama_guru']); ?></h3>
                            <p><?= htmlspecialchars($guru['jabatan']); ?></p>

                            <div class="d-flex justify-content-center align-items-center">
                                <?php if (!empty($guru['facebook'])) { ?>
                                    <a class="btn btn-square btn-primary mx-1" href="<?= $guru['facebook']; ?>">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                <?php } ?>

                                <?php if (!empty($guru['twitter'])) { ?>
                                    <a class="btn btn-square btn-primary mx-1" href="<?= $guru['twitter']; ?>">
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                <?php } ?>

                                <?php if (!empty($guru['instagram'])) { ?>
                                    <a class="btn btn-square btn-primary mx-1" href="<?= $guru['instagram']; ?>">
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>

                    </div>
                </div>
            <?php } ?>
        </div>

    </div>
</div>
<!-- Team End -->



        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>