<?php
include "config/koneksi.php";
$query = mysqli_query($conn, "SELECT * FROM infaq LIMIT 1");
$infaq = mysqli_fetch_assoc($query);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
    <style>
        /* Floating WhatsApp contact button */

        .page-header {
            background: linear-gradient(rgba(0, 0, 0, .2), rgba(0, 0, 0, .2)), url(img/infaq.jpeg) center center no-repeat;
            background-size: cover;
        }

        .wa-float {
            position: fixed;
            right: 20px;
            bottom: 20px;
            z-index: 99999;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: #25D366;
            color: #fff;
            padding: 10px 14px;
            border-radius: 50px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.2);
            text-decoration: none;
            font-weight: 600;
            transition: transform .12s ease, box-shadow .12s ease;
        }

        .wa-float:hover { transform: translateY(-2px); box-shadow: 0 8px 22px rgba(0,0,0,0.25); }

        .wa-float i { font-size: 20px; }

        .wa-float .wa-text { font-size: 13px; line-height: 1; display: inline-block; text-align: left; }
        .wa-float .wa-text .label { display:block; font-weight:700; }
        .wa-float .wa-text .number { display:block; font-size:12px; opacity:0.95; }

        .card-body i {
            color: #1b7e57;
        }

        /* Mobile: keep only the round icon to save space */
        @media (max-width: 576px) {
            .wa-float { padding: 10px; border-radius: 50%; gap:0; }
            .wa-float .wa-text { display: none; }
        }
    </style>
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
                <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link">Tentang Kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle active" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 shadow-sm m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item">Profil Guru</a>
                            <a href="Galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item active">Infaq</a>
                            <a href="Visi-Misi.php" class="dropdown-item">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Infaq</h1>
            </div>
        </div>
        <!-- Page Header End -->
<div class="container-xxl py-5">
    <div class="container text-center">
        <h1 class="mb-3">Infaq & Donasi</h1>
        <p class="mb-4">
            Salurkan infaq terbaik Anda untuk mendukung kegiatan pendidikan dan
            pengembangan Pondok Tahfidz Qur'an Al Luqman.
        </p>
    </div>
</div>


<div class="container-xxl pb-5">
    <div class="container">
        <div class="row g-4">

            <!-- Rekening Bank -->
            <div class="col-lg-4 col-md-6">
                <div class="card h-100 shadow-sm border-0 text-center">
                    <div class="card-body">
                        <i class="fa fa-university fa-3x mb-3"></i>
                        <h5 class="card-title">Transfer Bank</h5>
                        <p class="card-text mb-1"><strong><?= $infaq['bank_nama']; ?></strong></p>
                        <p class="mb-1">No. Rekening:</p>
                        <h6><?= $infaq['bank_rekening']; ?></h6>
                        <p class="mb-0">a.n <?= $infaq['bank_atas_nama']; ?></p>
                    </div>
                </div>
            </div>

            <!-- E-Wallet -->
            <div class="col-lg-4 col-md-6">
                <div class="card h-100 shadow-sm border-0 text-center">
                    <div class="card-body">
                        <i class="fa fa-wallet fa-3x  mb-3"></i>
                        <h5 class="card-title">E-Wallet</h5>
                        <p class="mb-1"><strong><?= $infaq['ewallet_nama']; ?></strong></p>
                        <h6><?= $infaq['ewallet_nomor']; ?></h6>
                        <p class="mb-0">a.n <?= $infaq['ewallet_atas_nama']; ?></p>
                    </div>
                </div>
            </div>

            <!-- Donasi Langsung -->
            <div class="col-lg-4 col-md-6">
                <div class="card h-100 shadow-sm border-0 text-center">
                    <div class="card-body">
                        <i class="fa fa-hand-holding-heart fa-3x mb-3"></i>
                        <h5 class="card-title">Donasi Langsung</h5>
                        <p class="mb-2">
                            Pondok Tahfidz Qur'an Al Luqman
                        </p>
                        <p class="mb-0">
                            Setiap hari <br>
                            <strong>08.00 – 16.00 WIB</strong>
                        </p>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- Floating WhatsApp contact button: replace number if needed -->
<a
        href="https://wa.me/6285296147188<?= preg_replace('/[^0-9]/', '', $infaq['whatsapp_nomor']); ?>?text=Assalamu%27alaikum%20saya%20ingin%20berinfaq%20di%20Yayasan%20Al-Luqman"
        class="wa-float"
        target="_blank"
        rel="noopener noreferrer">
        <i class="fab fa-whatsapp"></i>
        <span class="wa-text">
                <span class="label">Hubungi lebih lanjut</span>
                <span class="number">+6285296147188</span>
        </span>
</a>


        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
    <!-- Floating WhatsApp Button -->
</body>

</html>