<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <title>Pendaftaran Santri | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #f4f6f9;
    font-family: 'Heebo', sans-serif;
}

h1, h2, h3, h4 {
    font-family: 'Cinzel', serif;
    color: #066638;
}

.page-header {
    background: linear-gradient(rgba(0,0,0,.45), rgba(0,0,0,.45)),
                url('img/bg2.jpeg') center/cover no-repeat;
    padding: 90px 0;
    color: #fff;
    text-align: center;
}

.page-header h1 {
    color: #ffffff;
}

.form-wrapper {
    margin-top: -70px;
    margin-bottom: 70px;
}

.form-card {
    background: #ffffff;
    border-radius: 18px;
    padding: 40px;
    box-shadow: 0 15px 35px rgba(0,0,0,.1);
}

.form-control, .form-select {
    height: 48px;
    border-radius: 12px;
}

textarea.form-control {
    height: auto;
}

.form-control:focus, .form-select:focus {
    border-color: #1b7e57;
    box-shadow: 0 0 0 2px rgba(27,126,87,.15);
}

.btn-primary {
    color : #fff;
    background: #1b7e57;
    border: none;
    border-radius: 30px;
    padding: 12px 35px;
    font-weight: 500;
}

.btn-primary:hover {
    background: #145f42;
}

.btn-outline-secondary {
    border-radius: 30px;
    padding: 12px 35px;
    font-weight: 500;
}
</style>

</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Header -->
    <div class="page-header">
        <h1>Pendaftaran Santri Baru</h1>
        <p>Pondok Tahfidz Al-Luqman</p>
    </div>

    <!-- Form -->
    <div class="container form-wrapper">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="form-card">

<form action="kirim-wa.php" method="POST" enctype="multipart/form-data">

    <div class="row g-3">

        <div class="col-md-6">
            <label class="form-label">Nama Lengkap</label>
            <input type="text" name="nama" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Tempat Lahir</label>
            <input type="text" name="tempat_lahir" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Tanggal Lahir</label>
            <input type="date" name="tanggal_lahir" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">Jenis Kelamin</label>
            <select name="jk" class="form-control" required>
                <option value="">-- Pilih --</option>
                <option value="Laki-laki">Laki-laki</option>
                <option value="Perempuan">Perempuan</option>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label">Nama Orang Tua / Wali</label>
            <input type="text" name="wali" class="form-control" required>
        </div>

        <div class="col-md-6">
            <label class="form-label">No. HP Orang Tua / Wali</label>
            <input type="text" name="hp" class="form-control" required>
        </div>

        <div class="col-12">
            <label class="form-label">Alamat Lengkap</label>
            <textarea name="alamat" rows="4" class="form-control" required></textarea>
        </div>

        <div class="col-12">
            <label class="form-label">Pas Foto (JPG / PNG)</label>
            <input type="file" name="foto" class="form-control" accept="image/*" required>
        </div>

        <div class="col-12 text-center mt-4 d-flex gap-3 justify-content-center flex-wrap">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-paper-plane"></i> Daftar Sekarang
            </button>

            <a href="index.php" class="btn btn-outline-secondary">
                <i class="fa fa-arrow-left"></i> Kembali
            </a>
        </div>

    </div>
</form>


                </div>
            </div>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
