<?php
include "config/koneksi.php";

/* ======================
   AMBIL DATA KONTAK INFO
====================== */
$qInfo = mysqli_query($conn, "SELECT * FROM kontak_info LIMIT 1");
$info = mysqli_fetch_assoc($qInfo);

/* ======================
   SIMPAN PESAN
====================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nama    = trim($_POST['name']);
    $email   = trim($_POST['email']);
    $subjek  = trim($_POST['subject']);
    $telepon = trim($_POST['phone']);
    $pesan   = trim($_POST['message']);

    $stmt = $conn->prepare("
        INSERT INTO kontak_pesan 
        (nama, email, subjek, telepon, pesan, status)
        VALUES (?, ?, ?, ?, ?, 'baru')
    ");

    $stmt->bind_param(
        "sssss",
        $nama,
        $email,
        $subjek,
        $telepon,
        $pesan
    );

    if ($stmt->execute()) {
        echo "<script>alert('Pesan berhasil dikirim');</script>";
    } else {
        echo "<script>alert('Pesan gagal dikirim');</script>";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">

    <style>
        /* Override page header background untuk halaman kontak */
        .page-header {
            background: linear-gradient(rgba(0, 0, 0, .2), rgba(0, 0, 0, .2)), url(img/kontak2.jpg) center center no-repeat;
            background-size: cover;
        }

        /* Contact Section */
        .contact-section {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            padding: 80px 0;
        }

        .contact-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .contact-header h2 {
            font-family: 'Cinzel', serif;
            font-size: 2.5rem;
            color: #1b7e57;
            margin-bottom: 15px;
            font-weight: 700;
        }

        .contact-header p {
            font-size: 1.05rem;
            color: #666;
            max-width: 600px;
            margin: 0 auto;
        }

        /* Contact Info Cards */
        .contact-info-card {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            height: 100%;
        }

        .contact-info-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 40px rgba(27, 126, 87, 0.15);
        }

        .contact-info-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #1b7e57, #2d9f6f);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: #fff;
            font-size: 2.5rem;
            position: relative;
            box-shadow: 0 6px 20px rgba(27, 126, 87, 0.3);
        }

        .contact-info-icon i {
            line-height: 1;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .contact-info-icon::after {
            content: '';
            position: absolute;
            width: 12px;
            height: 12px;
            background: rgba(255, 255, 255, 0.4);
            border-radius: 50%;
            bottom: 8px;
            right: 8px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% {
                box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.7);
            }
            50% {
                box-shadow: 0 0 0 6px rgba(255, 255, 255, 0);
            }
        }

        .contact-info-card h5 {
            color: #1b7e57;
            font-family: 'Cinzel', serif;
            font-weight: 700;
            margin-bottom: 12px;
            font-size: 1.15rem;
        }

        .contact-info-card p {
            color: #666;
            margin: 0;
            font-size: 0.95rem;
            line-height: 1.6;
        }

        /* Contact Form Container */
        .contact-form-wrapper {
            background: #fff;
            border-radius: 20px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            margin-top: 50px;
        }

        .form-section {
            padding: 50px 45px;
        }

        .form-section h3 {
            font-family: 'Cinzel', serif;
            color: #1b7e57;
            font-size: 1.8rem;
            margin-bottom: 10px;
            font-weight: 700;
        }

        .form-divider {
            width: 60px;
            height: 3px;
            background: linear-gradient(90deg, #1b7e57, #2d9f6f);
            margin-bottom: 30px;
        }

        /* Form Styling */
        .form-floating {
            margin-bottom: 20px;
        }

        .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            padding: 14px 16px;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background-color: #f8f9fa;
        }

        .form-control:focus {
            border-color: #1b7e57;
            background-color: #fff;
            box-shadow: 0 0 0 3px rgba(27, 126, 87, 0.1);
        }

        .form-control::placeholder {
            color: #999;
        }

        .form-label {
            color: #1b7e57;
            font-weight: 600;
            font-size: 0.9rem;
        }

        /* Submit Button */
        .btn-submit {
            background: linear-gradient(135deg, #1b7e57, #2d9f6f);
            color: #fff;
            border: none;
            padding: 14px 40px;
            font-weight: 700;
            border-radius: 25px;
            transition: all 0.3s ease;
            font-size: 1rem;
        }

        .btn-submit:hover {
            background: linear-gradient(135deg, #145f42, #1b7e57);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(27, 126, 87, 0.3);
            color: #fff;
        }

        /* Map Section */
        .map-section {
            padding: 50px 45px;
            background: linear-gradient(135deg, #1b7e57 0%, #2d9f6f 100%);
            color: #fff;
        }

        .map-section h3 {
            font-family: 'Cinzel', serif;
            font-size: 1.8rem;
            margin-bottom: 10px;
            font-weight: 700;
            color: #fff;
        }

        .map-divider {
            width: 60px;
            height: 3px;
            background: rgba(255, 255, 255, 0.5);
            margin-bottom: 30px;
        }

        .map-info {
            margin-bottom: 25px;
            line-height: 1.8;
        }

        .map-info strong {
            font-weight: 700;
            display: block;
            margin-bottom: 5px;
        }

        .map-container {
            border-radius: 15px;
            overflow: hidden;
            margin-top: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }

        .map-container iframe {
            width: 100%;
            height: 400px;
            border: none;
        }

        /* Responsive */
        @media (max-width: 991px) {
            .contact-section {
                padding: 50px 0;
            }

            .contact-header h2 {
                font-size: 2rem;
            }

            .form-section,
            .map-section {
                padding: 40px 30px;
            }

            .form-section h3,
            .map-section h3 {
                font-size: 1.5rem;
            }

            .map-container iframe {
                height: 350px;
            }
        }

        @media (max-width: 576px) {
            .form-section,
            .map-section {
                padding: 30px 20px;
            }

            .form-section h3,
            .map-section h3 {
                font-size: 1.3rem;
            }

            .map-container iframe {
                height: 300px;
            }
        }
    </style>
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
                <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link">Tentang Kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item">Profil Guru</a>
                            <a href="galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item">Infaq</a>
                            <a href="visi-misi.php" class="dropdown-item">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link active">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Kontak Kami</h1>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Contact Start -->
        <div class="contact-section">
            <div class="container">
                <!-- Header -->
                <div class="contact-header wow fadeInUp" data-wow-delay="0.1s">
                    <h2>Hubungi Kami</h2>
                    <p>Kami siap melayani Anda dengan sepenuh hati. Jangan ragu untuk menghubungi kami melalui berbagai saluran komunikasi yang tersedia.</p>
                </div>

                <!-- Contact Info Cards -->
                <div class="row g-4 mb-5">
                    <!-- Alamat -->
                    <div class="col-md-6 col-lg-4 wow fadeInUp" data-wow-delay="0.2s">
                        <div class="contact-info-card">
                            <div class="contact-info-icon">
                                <i class="fas fa-map-location-dot"></i>
                            </div>
                            <h5><i class="fas fa-map-pin me-2" style="color: #1b7e57;"></i>Lokasi</h5>
                           <p><?= nl2br(htmlspecialchars($info['alamat'])) ?></p>
                        </div>
                    </div>

                    <!-- Email -->
                    <div class="col-md-6 col-lg-4 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="contact-info-card">
                            <div class="contact-info-icon">
                                <i class="fas fa-envelope"></i>
                            </div>
                            <h5><i class="fas fa-at me-2" style="color: #1b7e57;"></i>Email</h5>
                           <p>
<a href="mailto:<?= $info['email_utama'] ?>" style="color:#1b7e57;text-decoration:none;">
    <?= htmlspecialchars($info['email_utama']) ?>
</a><br>

<?php if(!empty($info['email_kedua'])): ?>
<a href="mailto:<?= $info['email_kedua'] ?>" style="color:#1b7e57;text-decoration:none;">
    <?= htmlspecialchars($info['email_kedua']) ?>
</a>
<?php endif; ?>
</p>

                        </div>
                    </div>

                    <!-- Telepon -->
                    <div class="col-md-6 col-lg-4 wow fadeInUp" data-wow-delay="0.4s">
                        <div class="contact-info-card">
                            <div class="contact-info-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <h5><i class="fas fa-phone-volume me-2" style="color: #1b7e57;"></i>Telepon</h5>
                           <p>
<a href="tel:<?= $info['telp_utama'] ?>" style="color:#1b7e57;text-decoration:none;">
    <?= htmlspecialchars($info['telp_utama']) ?>
</a><br>

<?php if(!empty($info['telp_kedua'])): ?>
<a href="tel:<?= $info['telp_kedua'] ?>" style="color:#1b7e57;text-decoration:none;">
    <?= htmlspecialchars($info['telp_kedua']) ?>
</a>
<?php endif; ?>
</p>

                    </div>
                </div>

                <!-- Contact Form & Map -->
                <div class="contact-form-wrapper wow fadeInUp" data-wow-delay="0.5s">
                    <div class="row g-0">
                        <!-- Form Section -->
                        <div class="col-lg-6">
                            <div class="form-section">
                                <h3>Kirim Pesan</h3>
                                <div class="form-divider"></div>
                                <form method="POST" action="">
                                    <div class="row g-3">
                                        <div class="col-sm-6">
                                            <div class="form-floating">
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Nama Anda" required>
                                                <label for="name">Nama Lengkap</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-floating">
                                                <input type="email" class="form-control" id="email" name="email" placeholder="Email Anda" required>
                                                <label for="email">Email</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-floating">
                                                <input type="text" class="form-control" id="subject" name="subject" placeholder="Subjek" required>
                                                <label for="subject">Subjek</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-floating">
                                                <input type="text" class="form-control" id="phone" name="phone" placeholder="Nomor Telepon">
                                                <label for="phone">Nomor Telepon (Opsional)</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="form-floating">
                                                <textarea class="form-control" id="message" name="message" placeholder="Pesan Anda" style="height: 120px;" required></textarea>
                                                <label for="message">Pesan</label>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <button class="btn btn-submit" type="submit">
                                                <i class="fas fa-paper-plane me-2"></i> Kirim Pesan
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <!-- Map Section -->
                        <div class="col-lg-6">
                            <div class="map-section">
                                <h3>Lokasi Kami</h3>
                                <div class="map-divider"></div>
                                <div class="map-info">
                                    <strong><i class="fas fa-map-pin me-2"></i> Alamat Lengkap</strong>
                                    Pondok Tahfidz Qur'an Al Luqman<br>
                                    Jl. Riwayat 1 Gg. Tower, Marindal 1, Kecamatan Patumbak, Kabupaten Deli Serdang Sumatera Utara. 
                                </div>
                                <div class="map-info">
                                    <strong><i class="fas fa-clock me-2"></i> Jam Operasional</strong>
                                    Senin - Jumat: 08:00 - 21:00<br>
                                    Sabtu - Minggu: 08:00 - 21:00
                                </div>
                                <div class="map-container">
                                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3982.260447771853!2d98.711389!3d3.527194699999999!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x30313b006c4c3955%3A0x357f1d9388be1406!2sPondok%20Tahfidz%20Qur&#39;an%20Al%20Luqman!5e0!3m2!1sid!2sid!4v1769436465905!5m2!1sid!2sid" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Contact End -->



        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->


        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>