<?php
session_start();
require '../config/koneksi.php';

$error = $success = "";

if (isset($_POST['ubah'])) {
    $username = trim($_POST['username']);
    $pass_lama = $_POST['pass_lama'];
    $pass_baru = $_POST['pass_baru'];
    $konfirmasi = $_POST['konfirmasi'];

    // Ambil data user
    $stmt = mysqli_prepare($conn, "SELECT id, password_hash FROM admin WHERE username=?");
    mysqli_stmt_bind_param($stmt,"s",$username);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($res);

    if (!$data) {
        $error = "Username tidak ditemukan!";
    } elseif (!password_verify($pass_lama, $data['password_hash'])) {
        $error = "Password lama salah!";
    } elseif ($pass_baru !== $konfirmasi) {
        $error = "Password baru dan konfirmasi tidak cocok!";
    } else {
        // Update password
        $hash = password_hash($pass_baru, PASSWORD_DEFAULT);
        $stmt2 = mysqli_prepare($conn, "UPDATE admin SET password_hash=? WHERE id=?");
        mysqli_stmt_bind_param($stmt2,"si",$hash,$data['id']);
        mysqli_stmt_execute($stmt2);
        $success = "Password berhasil diubah!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ubah Password | Login Admin</title>
<link href="../css/bootstrap.min.css" rel="stylesheet">
<style>
body{font-family:'Segoe UI',sans-serif;background:#f4f6f9;display:flex;justify-content:center;align-items:center;height:100vh;}
.container{background:#fff;padding:30px;border-radius:18px;box-shadow:0 15px 40px rgba(0,0,0,.12);width:400px;}
h3{color:#1b7e57;margin-bottom:20px;}
input{width:100%;padding:12px;margin-bottom:15px;border-radius:8px;border:1px solid #ccc;}
button{width:100%;padding:12px;background:#1b7e57;color:#fff;border:none;border-radius:30px;cursor:pointer;}
button:hover{background:#155f43;}
.error{background:#fdecea;color:#b71c1c;padding:10px;border-radius:8px;margin-bottom:15px;}
.success{background:#e6f4ea;color:#1b5e20;padding:10px;border-radius:8px;margin-bottom:15px;}
</style>
</head>
<body>
<div class="container">
<h3>Ubah Password</h3>
<?php if($error) echo "<div class='error'>$error</div>"; ?>
<?php if($success) echo "<div class='success'>$success</div>"; ?>
<form method="post">
<input type="text" name="username" placeholder="Username" required>
<input type="password" name="pass_lama" placeholder="Password Lama" required>
<input type="password" name="pass_baru" placeholder="Password Baru" required>
<input type="password" name="konfirmasi" placeholder="Konfirmasi Password Baru" required>
<button type="submit" name="ubah">Ubah Password</button>
</form>
<p style="margin-top:10px;text-align:center;"><a href="login.php" style="color:#1b7e57;">Kembali ke Login</a></p>
</div>
</body>
</html>
