<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/koneksi.php';

/* ===============================
   PROSES UPDATE
================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {

    $id     = intval($_POST['id']);
    $jenis  = strtolower($_POST['jenis']);
    $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
    $nominal = mysqli_real_escape_string($conn, $_POST['nominal']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);

    if ($jenis === 'pemasukan') {
        mysqli_query($conn, "
            UPDATE pemasukan SET
                tanggal='$tanggal',
                nominal='$nominal',
                keterangan='$keterangan'
            WHERE id_pemasukan=$id
        ");
    } else {
        mysqli_query($conn, "
            UPDATE pengeluaran SET
                tanggal='$tanggal',
                nominal='$nominal',
                keterangan='$keterangan'
            WHERE id=$id
        ");
    }

    header("Location: riwayat.php?status=update_sukses");
    exit;
}

/* ===============================
   AMBIL DATA EDIT
================================ */
$editData = null;
$editJenis = null;

if (isset($_GET['edit']) && isset($_GET['jenis'])) {

    $editId = intval($_GET['edit']);
    $editJenis = strtolower($_GET['jenis']);

    if ($editJenis === 'pemasukan') {
        $q = mysqli_query($conn, "SELECT * FROM pemasukan WHERE id_pemasukan=$editId");
    } else {
        $q = mysqli_query($conn, "SELECT * FROM pengeluaran WHERE id=$editId");
    }

    if ($q && mysqli_num_rows($q) > 0) {
        $editData = mysqli_fetch_assoc($q);
    }
}

/* ===============================
   FILTER TANGGAL
================================ */
$where = [];

if (!empty($_GET['tgl_awal']) && !empty($_GET['tgl_akhir'])) {
    $tgl_awal  = mysqli_real_escape_string($conn, $_GET['tgl_awal']);
    $tgl_akhir = mysqli_real_escape_string($conn, $_GET['tgl_akhir']);
    $where[] = "tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir'";
}

/* ===============================
   PAGINATION & AMBIL DATA
================================ */
$perPage = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $perPage;

// Query utama
$query = "SELECT * FROM riwayat_keuangan";
if (!empty($where)) {
    $query .= " WHERE " . implode(" AND ", $where);
}
$query .= " ORDER BY tanggal DESC LIMIT $perPage OFFSET $offset";
$result = mysqli_query($conn, $query);

// Total data untuk pagination
$total = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) AS total FROM riwayat_keuangan" . (!empty($where) ? " WHERE " . implode(" AND ", $where) : "")))['total'];
$totalPages = ceil($total / $perPage);

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Riwayat | Dashboard Admin</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="../img/bglogo.jpeg" rel="icon">
<link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
<link href="../css/bootstrap.min.css" rel="stylesheet">
<link href="../css/style.css" rel="stylesheet">

<style>
.dashboard-wrapper { display: flex; min-height: calc(100vh - 90px); }
.sidebar {
    width: 260px; background: #1b7e57; color: #fff;
    padding: 25px 20px;
}
.sidebar h4 { color: #fff;text-align: center; margin-bottom: 30px; }
.sidebar a {
    display: flex; align-items: center;
    color: #fff; padding: 12px 15px;
    margin-bottom: 10px; border-radius: 8px;
    text-decoration: none;
}
.sidebar a:hover, .sidebar a.active { background: #145f42; }
.dashboard-content { flex: 1; padding: 30px; background: #f4f6f9; }
.card { border-radius: 12px; box-shadow: 0 4px 10px rgba(0,0,0,.08); }

.pagination .page-link {
    background-color: #1b7e57;  /* warna latar belakang */
    color: #fff;                /* warna teks */
    border-color: #145f42;      /* warna border */
}

.pagination .page-link:hover {
    background-color: #145f42;  /* warna saat hover */
    color: #fff;
}

.pagination .page-item.active .page-link {
    background-color: #28a745;  /* warna halaman aktif */
    border-color: #28a745;
}


.badge-pemasukan { background:#28a745; }
.badge-pengeluaran { background:#dc3545; }

@media (max-width: 991px) {
    .dashboard-wrapper { flex-direction: column; }
    .sidebar {
        position: fixed; left: -300px; top: 70px;
        height: calc(100% - 70px); z-index: 1050;
        transition: left .3s;
    }
    .sidebar.open { left: 0; }
    .overlay {
        display: none; position: fixed; inset: 0;
        background: rgba(0,0,0,.35); z-index: 1040;
    }
    .overlay.show { display: block; }
}
</style>
</head>

<body>

<nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4">
    <a href="dashboard.php" class="navbar-brand">
        <h4 style="font-family:'Cinzel', serif; color:#1b7e57;">
            <img src="../img/bglogo.jpeg" width="30"> Dashboard Admin
        </h4>
    </a>
    <button class="btn btn-outline-secondary d-lg-none ms-auto" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </button>
</nav>

<div id="overlay" class="overlay" onclick="closeSidebar()"></div>

<div class="dashboard-wrapper">

<!-- Sidebar -->
<div class="sidebar">
    <h4>Menu Keuangan</h4>
    <a href="dashboard.php"><i class="fas fa-home me-2"></i>Dashboard</a>
    <a href="pemasukan.php"><i class="fas fa-arrow-down me-2"></i>Pemasukan</a>
    <a href="pengeluaran.php"><i class="fas fa-arrow-up me-2"></i>Pengeluaran</a>
    <a href="riwayat.php" class="active"><i class="fas fa-history me-2"></i>Riwayat</a>
    <a href="rekap.php"><i class="fas fa-chart-line me-2"></i>Rekap</a>
    <a href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
</div>

<!-- Content -->
<div class="dashboard-content">

<h3>Riwayat Transaksi Keuangan</h3>

<?php if(isset($_GET['status'])): ?>
<div class="alert alert-success">Data berhasil diperbarui</div>
<?php endif; ?>

<?php if($editData): ?>
<div class="card p-4 mb-4 border-warning">
<h5>Edit Transaksi</h5>
<form method="POST">
<input type="hidden" name="id" value="<?= $editData[$editJenis === 'pemasukan' ? 'id_pemasukan' : 'id']; ?>">
<input type="hidden" name="jenis" value="<?= $editJenis; ?>">

<div class="row">
<div class="col-md-3 mb-3">
<label>Tanggal</label>
<input type="date" name="tanggal" class="form-control"
value="<?= htmlspecialchars($editData['tanggal']); ?>" required>
</div>
<div class="col-md-3 mb-3">
<label>Nominal</label>
<input type="number" name="nominal" class="form-control"
value="<?= htmlspecialchars($editData['nominal']); ?>" required>
</div>
<div class="col-md-6 mb-3">
<label>Keterangan</label>
<input type="text" name="keterangan" class="form-control"
value="<?= htmlspecialchars($editData['keterangan']); ?>">
</div>
<div>
<button class="btn btn-warning">Update</button>
<a href="riwayat.php" class="btn btn-secondary">Batal</a>
</div>
</div>
</form>
</div>
<?php endif; ?>

<!-- FILTER -->
<div class="card p-4 mb-4">
<form method="GET" class="row g-3">
<div class="col-md-4">
<label>Dari Tanggal</label>
<input type="date" name="tgl_awal" class="form-control"
value="<?= $_GET['tgl_awal'] ?? '' ?>">
</div>
<div class="col-md-4">
<label>Sampai Tanggal</label>
<input type="date" name="tgl_akhir" class="form-control"
value="<?= $_GET['tgl_akhir'] ?? '' ?>">
</div>
<div class="col-md-4 d-flex align-items-end">
<button class="btn btn-success me-2">
<i class="fas fa-filter"></i> Filter
</button>
<a href="riwayat.php" class="btn btn-secondary">Reset</a>
</div>
</form>
</div>

<!-- TABLE -->
<div class="card p-4">
<div class="table-responsive">
<table class="table table-bordered table-hover align-middle">
<thead class="table-light">
<tr>
<th>No</th>
<th>Tanggal</th>
<th>Nama Donatur / PJ</th>
<th>Jenis</th>
<th>Kategori</th>
<th>Keterangan</th>
<th>Nominal</th>
<th>Aksi</th>
</tr>
</thead>
<tbody>

<?php
$no = ($page - 1) * $perPage + 1; // nomor urut sesuai halaman
if ($result && mysqli_num_rows($result) > 0):
while ($row = mysqli_fetch_assoc($result)):
$isPemasukan = strtolower($row['jenis_transaksi']) === 'pemasukan';
?>
<tr>
<td><?= $no++; ?></td>
<td><?= htmlspecialchars($row['tanggal']); ?></td>
<td><?= htmlspecialchars($row['pihak']); ?></td>
<td>
<span class="badge <?= $isPemasukan ? 'badge-pemasukan':'badge-pengeluaran'; ?>">
<?= htmlspecialchars($row['jenis_transaksi']); ?>
</span>
</td>
<td><?= htmlspecialchars($row['kategori']); ?></td>
<td><?= htmlspecialchars($row['keterangan']); ?></td>
<td class="<?= $isPemasukan?'text-success':'text-danger'; ?>">
Rp <?= number_format($row['nominal'],0,',','.'); ?>
</td>
<td>
<a href="riwayat.php?edit=<?= $row['id']; ?>&jenis=<?= strtolower($row['jenis_transaksi']); ?>"
class="btn btn-warning btn-sm">
Edit
</a>
</td>
</tr>
<?php endwhile; else: ?>
<tr>
<td colspan="8" class="text-center text-muted">Data tidak ditemukan</td>
</tr>
<?php endif; ?>

</tbody>
</table>

<!-- PAGINATION -->
<nav>
<ul class="pagination">
<?php if($page>1){ ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page-1 ?><?= !empty($_GET['tgl_awal'])?'&tgl_awal='.$_GET['tgl_awal']:'' ?><?= !empty($_GET['tgl_akhir'])?'&tgl_akhir='.$_GET['tgl_akhir']:'' ?>">Prev</a></li>
<?php } ?>
<?php for($i=1;$i<=$totalPages;$i++){ ?>
<li class="page-item <?= $i==$page?'active':'' ?>">
<a class="page-link" href="?page=<?= $i ?><?= !empty($_GET['tgl_awal'])?'&tgl_awal='.$_GET['tgl_awal']:'' ?><?= !empty($_GET['tgl_akhir'])?'&tgl_akhir='.$_GET['tgl_akhir']:'' ?>"><?= $i ?></a>
</li>
<?php } ?>
<?php if($page<$totalPages){ ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page+1 ?><?= !empty($_GET['tgl_awal'])?'&tgl_awal='.$_GET['tgl_awal']:'' ?><?= !empty($_GET['tgl_akhir'])?'&tgl_akhir='.$_GET['tgl_akhir']:'' ?>">Next</a></li>
<?php } ?>
</ul>
</nav>

</div>
</div>

</div>
</div>

<script>
const sidebarToggle = document.getElementById('sidebarToggle');
const sidebar = document.querySelector('.sidebar');
const overlay = document.getElementById('overlay');

sidebarToggle.onclick = () => {
    sidebar.classList.toggle('open');
    overlay.classList.toggle('show');
};

function closeSidebar() {
    sidebar.classList.remove('open');
    overlay.classList.remove('show');
}
</script>

<script src="../js/bootstrap.bundle.min.js"></script>
</body>
</html>
