<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/koneksi.php';
require_once __DIR__ . '/../vendor/dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* =========================
   AMBIL DATA RINGKASAN
========================= */
$qPemasukan = mysqli_query($conn,"SELECT IFNULL(SUM(nominal),0) total FROM pemasukan");
$totalPemasukan = mysqli_fetch_assoc($qPemasukan)['total'];

$qPengeluaran = mysqli_query($conn,"SELECT IFNULL(SUM(nominal),0) total FROM pengeluaran");
$totalPengeluaran = mysqli_fetch_assoc($qPengeluaran)['total'];

$saldo = $totalPemasukan - $totalPengeluaran;
$logoPath = __DIR__ . '/../img/bglogo.jpeg';
$logoType = pathinfo($logoPath, PATHINFO_EXTENSION);
$logoData = file_get_contents($logoPath);
$base64_logo = 'data:image/' . $logoType . ';base64,' . base64_encode($logoData);


/* =========================
   REKAP BULANAN
========================= */
$qBulanan = mysqli_query($conn, "
    SELECT periode,
           SUM(pemasukan) total_pemasukan,
           SUM(pengeluaran) total_pengeluaran
    FROM (
        SELECT DATE_FORMAT(tanggal,'%Y-%m') periode, nominal pemasukan, 0 pengeluaran FROM pemasukan
        UNION ALL
        SELECT DATE_FORMAT(tanggal,'%Y-%m') periode, 0 pemasukan, nominal pengeluaran FROM pengeluaran
    ) x
    GROUP BY periode
    ORDER BY periode DESC
");


/* =========================
   HTML + CSS (HEADER & FOOTER)
========================= */
$html = '
<head>
<meta charset="utf-8">
<title>Rekap | Dashboard Admin</title>

<link rel="icon" type="image/jpeg" href="/Yayasan/img/logoabout.jpeg">
</head>

<style>
@page {
    margin: 120px 40px 90px 40px;
}

body {
    font-family: DejaVu Sans;
    font-size: 12px;
}

/* HEADER */
.header {
    position: fixed;
    top: -100px;
    left: 0;
    right: 0;
    height: 90px;
    text-align: center;
}

.header h3 {
    margin: 0;
}

.header p {
    margin: 2px 0;
    font-size: 11px;
}

/* FOOTER */
.footer {
    position: fixed;
    bottom: -60px;
    left: 0;
    right: 0;
    height: 50px;
    text-align: center;
    font-size: 10px;
}

.pagenum:before {
    content: counter(page);
}

/* TABLE */
.table {
    width:100%;
    border-collapse:collapse;
    margin-top:10px;
}

.table th, .table td {
    border:1px solid #000;
    padding:6px;
}

.text-center { text-align:center; }
.text-right { text-align:right; }
</style>

<!-- HEADER -->
<div class="header">
    <table width="100%">
        <tr>
            <td width="15%" align="left">
                <img src="'.$base64_logo.'" width="70">
            </td>
            <td width="85%" class="text-center">
                <h3>YAYASAN CHALISATURAHMI LUKMAN HALIM</h3>
                <p>Jl. Bunga Rinti Komplek Puri Zahara 2 Blok E NO 34 Medan Selayang</p>
                <p>Telp: 085296147188</p>
            </td>
        </tr>
    </table>
    <hr>
</div>

<!-- FOOTER -->
<div class="footer">
    <hr>
    <p>
        Dicetak pada: '.date('d-m-Y').' |
        Halaman <span class="pagenum"></span>
    </p>
</div>

<h2 class="text-center">LAPORAN REKAPITULASI KEUANGAN</h2>
<h3 class="text-center">Periode Bulanan</h3>

<h3>Ringkasan Keuangan</h3>
<table class="table">
<tr>
    <th>Total Pemasukan</th>
    <td class="text-right">Rp '.number_format($totalPemasukan,0,',','.').'</td>
</tr>
<tr>
    <th>Total Pengeluaran</th>
    <td class="text-right">Rp '.number_format($totalPengeluaran,0,',','.').'</td>
</tr>
<tr>
    <th>Saldo Akhir</th>
    <td class="text-right">Rp '.number_format($saldo,0,',','.').'</td>
</tr>
</table>
';


$html .= '
</table>

<h3>Rekap Bulanan</h3>
<table class="table">
<tr>
    <th>Periode</th>
    <th>Pemasukan</th>
    <th>Pengeluaran</th>
    <th>Saldo</th>
</tr>
';

while($b = mysqli_fetch_assoc($qBulanan)){
    $saldoBulanan = $b['total_pemasukan'] - $b['total_pengeluaran'];
    $html .= '
    <tr>
        <td class="text-center">'.$b['periode'].'</td>
        <td class="text-right">Rp '.number_format($b['total_pemasukan'],0,',','.').'</td>
        <td class="text-right">Rp '.number_format($b['total_pengeluaran'],0,',','.').'</td>
        <td class="text-right">Rp '.number_format($saldoBulanan,0,',','.').'</td>
    </tr>';
}

$html .= '
</table>

<br><br>
<table width="100%">
<tr>
    <td width="60%"></td>
    <td class="text-center">
        <p>Mengetahui,</p>
        <br><br><br>
        <p><b>Dina Octavia S.Sos,M.I.Kom</b><br>Kepala  Yayasan<br><b>Medan</b>,..../...../........</br> </p>
    </td>
</tr>
</table>
';

/* =========================
   GENERATE PDF
========================= */
$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Laporan_Rekap_Keuangan.pdf", ["Attachment" => false]);
