<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/koneksi.php';

/* =========================
   TOTAL PEMASUKAN
========================= */
$qPemasukan = mysqli_query(
    $conn,
    "SELECT IFNULL(SUM(nominal),0) AS total FROM pemasukan"
);
$totalPemasukan = mysqli_fetch_assoc($qPemasukan)['total'];

/* =========================
   TOTAL PENGELUARAN
========================= */
$qPengeluaran = mysqli_query(
    $conn,
    "SELECT IFNULL(SUM(nominal),0) AS total FROM pengeluaran"
);
$totalPengeluaran = mysqli_fetch_assoc($qPengeluaran)['total'];

/* =========================
   SALDO
========================= */
$saldo = $totalPemasukan - $totalPengeluaran;

/* =========================
   REKAP BULANAN
========================= */
$qRekap = mysqli_query($conn, "
    SELECT 
        periode,
        SUM(pemasukan) AS total_pemasukan,
        SUM(pengeluaran) AS total_pengeluaran
    FROM (
        SELECT 
            DATE_FORMAT(tanggal,'%Y-%m') AS periode,
            nominal AS pemasukan,
            0 AS pengeluaran
        FROM pemasukan

        UNION ALL

        SELECT 
            DATE_FORMAT(tanggal,'%Y-%m') AS periode,
            0 AS pemasukan,
            nominal AS pengeluaran
        FROM pengeluaran
    ) x
    GROUP BY periode
    ORDER BY periode DESC
");

/* =========================
   REKAP TAHUNAN
========================= */
$qRekapTahunan = mysqli_query($conn, "
    SELECT 
        tahun,
        SUM(pemasukan) AS total_pemasukan,
        SUM(pengeluaran) AS total_pengeluaran
    FROM (
        SELECT 
            YEAR(tanggal) AS tahun,
            nominal AS pemasukan,
            0 AS pengeluaran
        FROM pemasukan

        UNION ALL

        SELECT 
            YEAR(tanggal) AS tahun,
            0 AS pemasukan,
            nominal AS pengeluaran
        FROM pengeluaran
    ) t
    GROUP BY tahun
    ORDER BY tahun DESC
");

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Rekap | Dashboard Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon & Bootstrap -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="../css/bootstrap.min.css" rel="stylesheet">
    <link href="../css/style.css" rel="stylesheet">

    <style>
        .dashboard-wrapper { display: flex; min-height: calc(100vh - 90px); }
        .sidebar {
            width: 260px; background: #1b7e57; color: #fff;
            padding: 25px 20px;
        }
        .sidebar h4 { color: #fff;text-align: center; margin-bottom: 30px; }
        .sidebar a {
            display: flex; align-items: center;
            color: #fff; padding: 12px 15px;
            margin-bottom: 10px; border-radius: 8px;
            text-decoration: none;
        }
        .sidebar a:hover, .sidebar a.active { background: #145f42; }
        .dashboard-content { flex: 1; padding: 30px; background: #f4f6f9; }
        .card { border-radius: 12px; box-shadow: 0 4px 10px rgba(0,0,0,.08); }

        @media (max-width: 991px) {
            .dashboard-wrapper { flex-direction: column; }
            .sidebar {
                position: fixed; left: -300px; top: 70px;
                height: calc(100% - 70px); z-index: 1050;
                transition: left .3s;
            }
            .sidebar.open { left: 0; }
            .overlay {
                display: none; position: fixed; inset: 0;
                background: rgba(0,0,0,.35); z-index: 1040;
            }
            .overlay.show { display: block; }
        }

        /* === TABLE SLIDE / HORIZONTAL SCROLL === */
.table-scroll {
    overflow-x: auto;
    width: 100%;
}

.table-scroll table {
    min-width: 1200px; /* paksa lebar jika kolom banyak */
    white-space: nowrap;
}

/* Optional: scroll bar lebih halus */
.table-scroll::-webkit-scrollbar {
    height: 8px;
}

.table-scroll::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 4px;
}

.table-wrapper {
    overflow-x: hidden;
}

.column-nav {
    display: flex;
    justify-content: end;
    gap: 10px;
    margin-bottom: 10px;
}

.column-nav button {
    padding: 5px 12px;
    font-size: 14px;
}

.hidden-col {
    display: none;
}

    </style>
</head>

<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4">
    <a href="dashboard.php" class="navbar-brand">
        <h4 style="font-family:'Cinzel', serif; color:#1b7e57;">
            <img src="../img/bglogo.jpeg" width="30"> Dashboard Admin
        </h4>
    </a>
    <button class="btn btn-outline-secondary d-lg-none ms-auto" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </button>
</nav>

<div id="overlay" class="overlay" onclick="closeSidebar()"></div>

<div class="dashboard-wrapper">

    <!-- Sidebar -->
    <div class="sidebar">
        <h4>Menu Keuangan</h4>
        <a href="dashboard.php"><i class="fas fa-home me-2"></i>Dashboard</a>
        <a href="pemasukan.php"><i class="fas fa-arrow-down me-2"></i>Pemasukan</a>
        <a href="pengeluaran.php"><i class="fas fa-arrow-up me-2"></i>Pengeluaran</a>
        <a href="riwayat.php"><i class="fas fa-history me-2"></i>Riwayat</a>
        <a href="rekap.php" class="active"><i class="fas fa-chart-line me-2"></i>Rekap</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
    </div>

    <!-- Content -->
    <div class="dashboard-content">
        <h3>Rekap Laporan Keuangan</h3>

        <!-- RINGKASAN -->
        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="card p-4 text-center">
                    <i class="fas fa-arrow-down text-success fs-3 mb-2"></i>
                    <h6>Total Pemasukan</h6>
                    <h4 class="text-success">
                        Rp <?= number_format($totalPemasukan,0,',','.'); ?>
                    </h4>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card p-4 text-center">
                    <i class="fas fa-arrow-up text-danger fs-3 mb-2"></i>
                    <h6>Total Pengeluaran</h6>
                    <h4 class="text-danger">
                        Rp <?= number_format($totalPengeluaran,0,',','.'); ?>
                    </h4>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card p-4 text-center">
                    <div class="icon text-primary">
                    <i class="fas fa-wallet fs-3 mb-2"></i>
                    <h6>Saldo Akhir</h6>
                    <h4 class="text-primary">
                        Rp <?= number_format($saldo,0,',','.'); ?>
                    </h4>
                </div>
            </div>
        </div>

                <!-- REKAP TAHUNAN -->
        <div class="card p-4 mb-4">
            <h5 class="mb-3">Rekap Tahunan</h5>
            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Tahun</th>
                            <th>Total Pemasukan</th>
                            <th>Total Pengeluaran</th>
                            <th>Saldo</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(mysqli_num_rows($qRekapTahunan) > 0): ?>
                        <?php while($row = mysqli_fetch_assoc($qRekapTahunan)):
                            $saldoTahunan = $row['total_pemasukan'] - $row['total_pengeluaran'];
                        ?>
                        <tr>
                            <td class="fw-bold"><?= $row['tahun']; ?></td>
                            <td class="text-success">
                                Rp <?= number_format($row['total_pemasukan'],0,',','.'); ?>
                            </td>
                            <td class="text-danger">
                                Rp <?= number_format($row['total_pengeluaran'],0,',','.'); ?>
                            </td>
                            <td class="text-primary fw-semibold">
                                Rp <?= number_format($saldoTahunan,0,',','.'); ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">
                                Data rekap tahunan belum tersedia
                            </td>
                        </tr>
                    <?php endif; ?>
                    <a href="rekap_tahunan.php" target="_blank" class="btn btn-danger mb-3">
                        <i class="fas fa-file-pdf"></i> Export PDF
                    </a>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- REKAP BULANAN -->
        <div class="card p-4">
            <h5 class="mb-3">Rekap Bulanan</h5>
            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Periode</th>
                            <th>Total Pemasukan</th>
                            <th>Total Pengeluaran</th>
                            <th>Saldo</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php if(mysqli_num_rows($qRekap) > 0): ?>
                        <?php while($row = mysqli_fetch_assoc($qRekap)):
                            $saldoBulanan = $row['total_pemasukan'] - $row['total_pengeluaran'];
                        ?>
                        <tr>
                            <td><?= $row['periode']; ?></td>
                            <td class="text-success">
                                Rp <?= number_format($row['total_pemasukan'],0,',','.'); ?>
                            </td>
                            <td class="text-danger">
                                Rp <?= number_format($row['total_pengeluaran'],0,',','.'); ?>
                            </td>
                            <td class="text-primary">
                                Rp <?= number_format($saldoBulanan,0,',','.'); ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-muted">
                                Data rekap bulanan belum tersedia
                            </td>
                        </tr>
                    <?php endif; ?>

                    <a href="rekap_bulanan.php" target="_blank" class="btn btn-danger mb-3">
                        <i class="fas fa-file-pdf"></i> Export PDF
                    </a>
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<script>
const sidebarToggle = document.getElementById('sidebarToggle');
const sidebar = document.querySelector('.sidebar');
const overlay = document.getElementById('overlay');

sidebarToggle.onclick = () => {
    sidebar.classList.toggle('open');
    overlay.classList.toggle('show');
};

function closeSidebar() {
    sidebar.classList.remove('open');
    overlay.classList.remove('show');
}
</script>

<script src="../js/bootstrap.bundle.min.js"></script>
</body>
</html>
