<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

/* ===============================
   PROSES SIMPAN DATA PENGELUARAN
   =============================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $tanggal            = $_POST['tanggal'];
    $kategori           = $_POST['kategori'];
    $penanggung_jawab   = !empty($_POST['penanggung_jawab']) ? $_POST['penanggung_jawab'] : null;
    $nominal            = $_POST['nominal'];
    $metode             = $_POST['metode'];
    $keterangan         = !empty($_POST['keterangan']) ? $_POST['keterangan'] : null;

    $sql = "INSERT INTO pengeluaran 
            (tanggal, kategori, penanggung_jawab, nominal, metode, keterangan)
            VALUES (?, ?, ?, ?, ?, ?)";

    $stmt = mysqli_prepare($conn, $sql);
    if (!$stmt) {
        die("Prepare gagal: " . mysqli_error($conn));
    }

    mysqli_stmt_bind_param(
        $stmt,
        "sssiss",
        $tanggal,
        $kategori,
        $penanggung_jawab,
        $nominal,
        $metode,
        $keterangan
    );

    if (mysqli_stmt_execute($stmt)) {
        header("Location: pengeluaran.php?status=success");
        exit;
    } else {
        $error = "Gagal menyimpan data pengeluaran!";
    }

    mysqli_stmt_close($stmt);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Pengeluaran | Dashboard Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">
    <link href="../css/style.css" rel="stylesheet">

    <!-- Custom Dashboard Style -->
    <style>
        .dashboard-wrapper { display: flex; min-height: calc(100vh - 90px); }
        .sidebar {
            width: 260px;
            background: #1b7e57;
            color: #fff;
            padding: 25px 20px;
        }
        .sidebar h4 {
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
            color: #fff;
        }
        .sidebar a {
            display: flex;
            align-items: center;
            color: #fff;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-decoration: none;
            transition: .3s;
        }
        .sidebar a i { margin-right: 12px; }
        .sidebar a:hover, .sidebar a.active { background: #145f42; }
        .dashboard-content {
            flex: 1;
            padding: 30px;
            background: #f4f6f9;
        }
        .card {
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.08);
        }

        @media (max-width: 991px) {
            .dashboard-wrapper { flex-direction: column; }
            .sidebar {
                position: fixed;
                left: -300px;
                top: 70px;
                height: calc(100% - 70px);
                z-index: 1050;
                transition: left .3s;
            }
            .sidebar.open { left: 0; }
            .overlay {
                display: none;
                position: fixed;
                inset: 0;
                background: rgba(0,0,0,.35);
                z-index: 1040;
            }
            .overlay.show { display: block; }
        }
    </style>
</head>

<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg bg-white sticky-top px-4">
    <a href="dashboard.php" class="navbar-brand">
        <h4 style="font-family:'Cinzel',serif;color:#1b7e57">
            <img src="../img/bglogo.jpeg" width="30" class="me-2">
            Dashboard Admin
        </h4>
    </a>
    <button class="btn btn-outline-secondary d-lg-none ms-auto" id="sidebarToggle">
        <i class="fas fa-bars"></i>
    </button>
</nav>

<div id="overlay" class="overlay" onclick="closeSidebar()"></div>

<div class="dashboard-wrapper">

    <!-- Sidebar -->
    <div class="sidebar">
        <h4>Menu Keuangan</h4>
        <a href="dashboard.php"><i class="fas fa-home"></i>Dashboard</a>
        <a href="pemasukan.php"><i class="fas fa-arrow-down"></i>Pemasukan</a>
        <a href="pengeluaran.php" class="active"><i class="fas fa-arrow-up"></i>Pengeluaran</a>
        <a href="riwayat.php"><i class="fas fa-history"></i>Riwayat</a>
        <a href="rekap.php"><i class="fas fa-chart-line"></i>Rekap</a>
        <a href="logout.php" style="background:rgba(255,255,255,.1)">
            <i class="fas fa-sign-out-alt"></i>Logout
        </a>
    </div>

    <!-- Content -->
    <div class="dashboard-content">

        <h3>Input Data Pengeluaran</h3>

        <?php if (isset($_GET['status']) && $_GET['status'] === 'success'): ?>
            <div class="alert alert-success">Data pengeluaran berhasil disimpan ✅</div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <div class="card p-4">
            <form method="post">
                <div class="row g-3">

                    <div class="col-md-4">
                        <label>Tanggal</label>
                        <input type="date" name="tanggal" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label>Kategori</label>
                        <select name="kategori" class="form-control" required>
                            <option value="">-- Pilih --</option>
                            <option>Operasional</option>
                            <option>Gaji / Honor</option>
                            <option>Konsumsi</option>
                            <option>Pendidikan</option>
                            <option>Perawatan Gedung</option>
                            <option>Listrik & Air</option>
                            <option>Lainnya</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Penanggung Jawab</label>
                        <input type="text" name="penanggung_jawab" class="form-control">
                    </div>

                    <div class="col-md-6">
                        <label>Nominal</label>
                        <input type="number" name="nominal" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Metode</label>
                        <select name="metode" class="form-control" required>
                            <option value="">-- Pilih --</option>
                            <option>Cash</option>
                            <option>Transfer Bank</option>
                            <option>E-Wallet</option>
                        </select>
                    </div>

                    <div class="col-12">
                        <label>Keterangan</label>
                        <textarea name="keterangan" class="form-control"></textarea>
                    </div>

                    <div class="col-12 text-end mt-3">
                        <button type="reset" class="btn btn-secondary">
                            <i class="fas fa-undo"></i> Reset
                        </button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-save"></i> Simpan
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>

<script>
const sidebarToggle = document.getElementById('sidebarToggle');
const sidebar = document.querySelector('.sidebar');
const overlay = document.getElementById('overlay');

sidebarToggle.addEventListener('click', () => {
    sidebar.classList.toggle('open');
    overlay.classList.toggle('show');
});

function closeSidebar() {
    sidebar.classList.remove('open');
    overlay.classList.remove('show');
}
</script>

<script src="../js/bootstrap.bundle.min.js"></script>
</body>
</html>
