<?php
session_start();

/*
 | Jika tombol logout ditekan (POST)
 */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_logout'])) {
    $_SESSION = [];
    session_unset();
    session_destroy();

    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Logout | Admin Panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Icon -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(135deg, #eaf7f2, #f6fbf9);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .logout-card {
            background: #fff;
            border-radius: 16px;
            padding: 35px;
            width: 100%;
            max-width: 420px;
            box-shadow: 0 15px 40px rgba(0,0,0,.12);
            text-align: center;
            animation: fadeIn .3s ease;
        }

        .logout-icon {
            font-size: 48px;
            color: #dc3545;
            margin-bottom: 15px;
        }

        .logout-card h4 {
            margin-bottom: 10px;
            color: #103741;
        }

        .logout-card p {
            font-size: 14px;
            color: #666;
            margin-bottom: 25px;
        }

        .btn-logout {
            background: #dc3545;
            color: #fff;
            border-radius: 30px;
            padding: 10px 22px;
            border: none;
        }

        .btn-logout:hover {
            background: #b52a37;
        }

        .btn-cancel {
            border-radius: 30px;
            padding: 10px 22px;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(.95); }
            to { opacity: 1; transform: scale(1); }
        }
    </style>
</head>
<body>

<div class="logout-card">
    <div class="logout-icon">
        <i class="fas fa-sign-out-alt"></i>
    </div>

    <h4>Konfirmasi Logout</h4>
    <p>
        Apakah Anda yakin ingin keluar dari<br>
        <strong>Dashboard Admin</strong>?
    </p>

    <form method="post">
        <button type="submit" name="confirm_logout" class="btn btn-logout me-2">
            Ya, Logout
        </button>
        <a href="dashboard.php" class="btn btn-secondary btn-cancel">
            Batal
        </a>
    </form>
</div>

</body>
</html>