<?php
session_start();
require '../config/koneksi.php';

$error = "";

if (isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = mysqli_prepare($conn, "SELECT id, username, password_hash, nama FROM admin WHERE username = ?");
    mysqli_stmt_bind_param($stmt, "s", $username);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $data = mysqli_fetch_assoc($result);

    if ($data && password_verify($password, $data['password_hash'])) {
        session_regenerate_id(true);

        $_SESSION['admin_login'] = true;
        $_SESSION['admin_id']    = $data['id'];
        $_SESSION['admin_nama']  = $data['nama'];

        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Username atau Password salah!";
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login Admin | Yayasan Luqman Hakim</title>
    
    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', sans-serif;
        }

        body {
            background: linear-gradient(135deg, #eaf7f2, #f6fbf9);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            width: 900px;
            height: 520px;
            background: #fff;
            border-radius: 18px;
            display: flex;
            overflow: hidden;
            box-shadow: 0 15px 40px rgba(0,0,0,.12);
        }

        /* ===== KIRI (LOGO) ===== */
        .login-left {
            width: 55%;
            background: #1b7e57;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .image-box {
            text-align: center;
            color: #fff;
            padding: 30px;
        }

        .image-box img {
            width: 220px;
            margin-bottom: 20px;
            border-radius: 10px;
        }

        .image-box h2 {
            font-weight: 600;
            margin-bottom: 10px;
        }

        .image-box p {
            font-size: 15px;
            line-height: 1.6;
            opacity: .95;
        }

        /* ===== KANAN (FORM) ===== */
        .login-right {
            width: 45%;
            padding: 50px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .title {
            font-size: 28px;
            margin-bottom: 25px;
            color: #103741;
        }

        .title span {
            color: #1b7e57;
        }

        .form-group {
            margin-bottom: 18px;
        }

        .form-group label {
            font-size: 14px;
            color: #555;
        }

        .form-group input {
            width: 100%;
            padding: 12px;
            margin-top: 6px;
            border-radius: 8px;
            border: 1px solid #ccc;
            outline: none;
            transition: .3s;
        }

        .form-group input:focus {
            border-color: #1b7e57;
        }

        .btn-login {
            width: 100%;
            background: #1b7e57;
            color: #fff;
            padding: 13px;
            border: none;
            border-radius: 30px;
            font-size: 15px;
            cursor: pointer;
            transition: .3s;
            margin-top: 10px;
        }

        .btn-login:hover {
            background: #155f43;
        }

        .error {
            background: #fdecea;
            color: #b71c1c;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-size: 14px;
        }

        .footer-text {
            margin-top: 30px;
            font-size: 12px;
            color: #888;
            text-align: center;
        }

        /* ===== RESPONSIVE ===== */
        @media(max-width: 768px) {
            .login-container {
                flex-direction: column;
                height: auto;
                width: 90%;
            }

            .login-left,
            .login-right {
                width: 100%;
            }

            .login-left {
                padding: 40px 0;
            }
        }
    </style>
</head>
<body>

<div class="login-container">

    <!-- KIRI : LOGO -->
    <div class="login-left">
        <div class="image-box">
            <img src="../img/bglogo.jpeg" alt="Logo Yayasan">
            <h2>Yayasan Al Luqman</h2>
            <p>
                Sistem Informasi Keuangan<br>
                Transparan • Aman • Terpercaya
            </p>
        </div>
    </div>

    <!-- KANAN : FORM LOGIN -->
    <div class="login-right">
        <h1 class="title">Login Admin</h1>

        <?php if ($error): ?>
            <div class="error"><?= $error ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <label>Username</label>
                <input type="text" name="username" placeholder="Masukkan username" required>
            </div>

            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" placeholder="Masukkan password" required>
            </div>

            <button type="submit" name="login" class="btn-login">
                Login
            </button>

                <p style="margin-top:15px; font-size:14px; text-align:right;">
                <a href="ubah-password-login.php" style="color:#1b7e57; text-decoration:underline;">
                    Ubah Password
                </a>
    </p>
        </form>

        <p class="footer-text">
            © <?= date('Y'); ?> Pondok Tahfidz Al Luqman
        </p>
    </div>

</div>

</body>
</html>
