<?php
require 'vendor/autoload.php';
require 'koneksi.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// ======================
// SET OPTION DOMPDF
// ======================
$options = new Options();
$options->set('defaultFont', 'Helvetica');
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);

// ======================
// AMBIL DATA PEMASUKAN
// ======================
$pemasukan = mysqli_query($conn, "SELECT * FROM pemasukan ORDER BY tanggal DESC");
$total_pemasukan = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT SUM(jumlah) AS total FROM pemasukan")
)['total'] ?? 0;

// ======================
// AMBIL DATA PENGELUARAN
// ======================
$pengeluaran = mysqli_query($conn, "SELECT * FROM pengeluaran ORDER BY tanggal DESC");
$total_pengeluaran = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT SUM(jumlah) AS total FROM pengeluaran")
)['total'] ?? 0;

$saldo = $total_pemasukan - $total_pengeluaran;

// ======================
// HTML LAPORAN
// ======================
$html = '
<style>
    body { font-family: Helvetica; font-size: 12px; }
    h2, h3 { text-align: center; margin-bottom: 5px; }
    .info { text-align:center; margin-bottom:20px; }
    table { width:100%; border-collapse: collapse; margin-bottom: 20px; }
    th, td { border:1px solid #000; padding:6px; }
    th { background:#1b7e57; color:#fff; }
    .right { text-align:right; }
    .total { font-weight:bold; }
</style>

<h2>LAPORAN KEUANGAN YAYASAN</h2>
<div class="info">
    Periode Laporan<br>
    Tanggal Cetak: '.date('d-m-Y').'
</div>

<h3>Data Pemasukan</h3>
<table>
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Sumber Dana</th>
    <th>Keterangan</th>
    <th>Jumlah (Rp)</th>
</tr>';

$no = 1;
while ($row = mysqli_fetch_assoc($pemasukan)) {
    $html .= '
    <tr>
        <td>'.$no++.'</td>
        <td>'.date('d-m-Y', strtotime($row['tanggal'])).'</td>
        <td>'.$row['sumber'].'</td>
        <td>'.$row['keterangan'].'</td>
        <td class="right">'.number_format($row['jumlah'],0,',','.').'</td>
    </tr>';
}

$html .= '
<tr class="total">
    <td colspan="4">Total Pemasukan</td>
    <td class="right">Rp '.number_format($total_pemasukan,0,',','.').'</td>
</tr>
</table>

<h3>Data Pengeluaran</h3>
<table>
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Keperluan</th>
    <th>Keterangan</th>
    <th>Jumlah (Rp)</th>
</tr>';

$no = 1;
while ($row = mysqli_fetch_assoc($pengeluaran)) {
    $html .= '
    <tr>
        <td>'.$no++.'</td>
        <td>'.date('d-m-Y', strtotime($row['tanggal'])).'</td>
        <td>'.$row['keperluan'].'</td>
        <td>'.$row['keterangan'].'</td>
        <td class="right">'.number_format($row['jumlah'],0,',','.').'</td>
    </tr>';
}

$html .= '
<tr class="total">
    <td colspan="4">Total Pengeluaran</td>
    <td class="right">Rp '.number_format($total_pengeluaran,0,',','.').'</td>
</tr>
<tr class="total">
    <td colspan="4">Saldo Akhir</td>
    <td class="right">Rp '.number_format($saldo,0,',','.').'</td>
</tr>
</table>
';

// ======================
// GENERATE PDF
// ======================
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Laporan_Keuangan_Yayasan.pdf", [
    "Attachment" => false
]);
