<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

if (!$conn) die("Koneksi database tidak tersedia");

// Helper
function e($v){ return htmlspecialchars($v ?? '', ENT_QUOTES); }

// ================= DELETE =================
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];

    $q = mysqli_query($conn,"SELECT gambar FROM program WHERE id_program=$id");
    if ($q && $row=mysqli_fetch_assoc($q)) {
        if ($row['gambar'] && file_exists(__DIR__.'/../'.$row['gambar'])) {
            unlink(__DIR__.'/../'.$row['gambar']);
        }
    }

    mysqli_query($conn,"DELETE FROM program WHERE id_program=$id");
    header("Location: edit-program.php");
    exit;
}

// ================= CREATE / UPDATE =================
if ($_SERVER['REQUEST_METHOD']==='POST') {

    $isUpdate = isset($_POST['id']) && is_numeric($_POST['id']);
    $id = $isUpdate ? (int)$_POST['id'] : null;

    $urutan  = $_POST['urutan'];
    $judul   = $_POST['judul'];
    $highlight = $_POST['highlight'];
    $jam_mulai = $_POST['jam_mulai'];
    $jam_selesai = $_POST['jam_selesai'];
    $keterangan = $_POST['keterangan_waktu'];
    $deskripsi  = $_POST['deskripsi'];
    $link_daftar = $_POST['link_daftar'];
    $status = $_POST['status'];

    // Upload gambar
    $gambar = null;
    if (!empty($_FILES['gambar']['name'])) {
        $dir = __DIR__.'/../uploads/program/';
        if (!is_dir($dir)) mkdir($dir,0777,true);

        $ext = pathinfo($_FILES['gambar']['name'],PATHINFO_EXTENSION);
        $file = time().'_program.'.$ext;
        move_uploaded_file($_FILES['gambar']['tmp_name'],$dir.$file);
        $gambar = 'uploads/program/'.$file;

        if ($isUpdate) {
            $old = mysqli_fetch_assoc(mysqli_query($conn,"SELECT gambar FROM program WHERE id_program=$id"));
            if ($old && $old['gambar'] && file_exists(__DIR__.'/../'.$old['gambar'])) {
                unlink(__DIR__.'/../'.$old['gambar']);
            }
        }
    }

    if ($isUpdate) {
        if ($gambar) {
            $sql="UPDATE program SET urutan=?,judul=?,gambar=?,highlight=?,jam_mulai=?,jam_selesai=?,keterangan_waktu=?,deskripsi=?,link_daftar=?,status=? WHERE id_program=?";
            $stmt=mysqli_prepare($conn,$sql);
            mysqli_stmt_bind_param($stmt,"isssssssssi",$urutan,$judul,$gambar,$highlight,$jam_mulai,$jam_selesai,$keterangan,$deskripsi,$link_daftar,$status,$id);
        } else {
            $sql="UPDATE program SET urutan=?,judul=?,highlight=?,jam_mulai=?,jam_selesai=?,keterangan_waktu=?,deskripsi=?,link_daftar=?,status=? WHERE id_program=?";
            $stmt=mysqli_prepare($conn,$sql);
            mysqli_stmt_bind_param($stmt,"issssssssi",$urutan,$judul,$highlight,$jam_mulai,$jam_selesai,$keterangan,$deskripsi,$link_daftar,$status,$id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        $sql="INSERT INTO program (urutan,judul,gambar,highlight,jam_mulai,jam_selesai,keterangan_waktu,deskripsi,link_daftar,status)
              VALUES (?,?,?,?,?,?,?,?,?,?)";
        $stmt=mysqli_prepare($conn,$sql);
        mysqli_stmt_bind_param($stmt,"isssssssss",$urutan,$judul,$gambar,$highlight,$jam_mulai,$jam_selesai,$keterangan,$deskripsi,$link_daftar,$status);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    header("Location: edit-program.php");
    exit;
}

// ================= LOAD DATA =================
$editing=null;
if (isset($_GET['edit'])) {
    $id=(int)$_GET['edit'];
    $res=mysqli_query($conn,"SELECT * FROM program WHERE id_program=$id");
    if ($res && mysqli_num_rows($res)>0) $editing=mysqli_fetch_assoc($res);
}
$list=mysqli_query($conn,"SELECT * FROM program ORDER BY urutan ASC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Edit Program | Yayasan Al-Luqman</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="../img/bglogo.jpeg" rel="icon">
<link href="../css/bootstrap.min.css" rel="stylesheet">
<link href="../css/style.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

<style>
.admin-container{display:flex;min-height:calc(100vh - 90px)}
.admin-sidebar{width:260px;background:#1b7e57;color:#fff;padding:25px}
.admin-sidebar h4 { color: #fff; text-align: center; margin-bottom: 30px; font-weight: 600; }
.admin-sidebar a{display:flex;align-items:center;color:#fff;padding:12px;border-radius:8px;text-decoration:none;margin-bottom:10px}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#145f42}
.admin-content{flex:1;padding:30px;background:#f5f9f4}
.edit-card{background:#fff;padding:25px;border-radius:12px;box-shadow:0 4px 10px rgba(0,0,0,.08)}
.form-group{margin-bottom:18px}
.form-group label{font-weight:600;color:#1b7e57}
.btn-save{background:#1b7e57;color:#fff;padding:12px 30px;border:none;border-radius:8px}
.btn-back{background:#6c757d;color:#fff;padding:12px 30px;border-radius:8px;text-decoration:none}
@media(max-width:991px){
.admin-container{flex-direction:column}
.admin-sidebar{width:100%}
}
</style>
</head>

<body>

<nav class="navbar bg-white px-4">
<h4 style="font-family:'Cinzel',serif;color:#1b7e57">
<img src="../img/bglogo.jpeg" width="30"> Dashboard Admin
</h4>
</nav>

<div class="admin-container">

<div class="admin-sidebar">
<h4 class="text-center mb-4">Menu</h4>
<a href="dashboard.php"><i class="fas fa-home me-2"></i> Dashboard</a>
<a href="edit-program.php" class="active"><i class="fas fa-book me-2"></i> Konten Program</a>
<a href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a>
</div>

<div class="admin-content">
<h3 class="mb-4">📘 Edit Program</h3>

<div class="edit-card mb-4">
<h5>Daftar Program</h5>
<div style="overflow:auto">
<table class="table">
<tr><th>#</th><th>Gambar</th><th>Judul</th><th>Status</th><th>Aksi</th></tr>
<?php $i=1; while($r=mysqli_fetch_assoc($list)): ?>
<tr>
<td><?= $i++ ?></td>
<td><?php if($r['gambar']): ?><img src="../<?= e($r['gambar']) ?>" height="60"><?php endif; ?></td>
<td><?= e($r['judul']) ?></td>
<td><?= e($r['status']) ?></td>
<td>
<a href="?edit=<?= $r['id_program'] ?>" class="btn btn-sm btn-primary">Edit</a>
<a href="?delete=<?= $r['id_program'] ?>" onclick="return confirm('Hapus data?')" class="btn btn-sm btn-danger">Hapus</a>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>

<hr>
<h5><?= $editing?'Edit Program':'Tambah Program'; ?></h5>

<form method="POST" enctype="multipart/form-data">
<?php if($editing): ?><input type="hidden" name="id" value="<?= $editing['id_program'] ?>"><?php endif; ?>

<div class="form-group">
<label>Urutan</label>
<input type="number" name="urutan" class="form-control" value="<?= e($editing['urutan']??'') ?>" required>
</div>

<div class="form-group">
<label>Judul</label>
<input type="text" name="judul" class="form-control" value="<?= e($editing['judul']??'') ?>" required>
</div>

<div class="form-group">
<label>Highlight</label>
<input type="text" name="highlight" class="form-control" value="<?= e($editing['highlight']??'') ?>">
</div>

<div class="form-group">
<label>Gambar</label><br>
<?php if($editing && $editing['gambar']): ?><img src="../<?= e($editing['gambar']) ?>" height="80"><br><?php endif; ?>
<input type="file" name="gambar">
</div>
<div class="form-group">
<label>Jam Mulai</label>
<input type="time" name="jam_mulai" class="form-control" 
value="<?= e($editing['jam_mulai']??'') ?>">
</div>

<div class="form-group">
<label>Jam Selesai</label>
<input type="time" name="jam_selesai" class="form-control" 
value="<?= e($editing['jam_selesai']??'') ?>">
</div>

<div class="form-group">
<label>Keterangan Waktu</label>
<input type="text" name="keterangan_waktu" class="form-control" 
value="<?= e($editing['keterangan_waktu']??'') ?>">
</div>

<div class="form-group">
<label>Link Daftar</label>
<input type="text" name="link_daftar" class="form-control" 
value="<?= e($editing['link_daftar']??'') ?>">
</div>

<div class="form-group">
<label>Status</label>
<select name="status" class="form-control" required>
    <option value="aktif" <?= (isset($editing['status']) && $editing['status']=='aktif')?'selected':'' ?>>Aktif</option>
    <option value="nonaktif" <?= (isset($editing['status']) && $editing['status']=='nonaktif')?'selected':'' ?>>Nonaktif</option>
</select>
</div>

<div class="form-group">
<label>Deskripsi</label>
<textarea id="summernote" name="deskripsi"><?= e($editing['deskripsi']??'') ?></textarea>
</div>

<div class="mt-3 d-flex gap-2">
<button class="btn-save">Tambah</button>
<a href="edit-program.php" class="btn-back">Batal</a>
</div>
</form>

</div>
</div>
</div>

<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<script>
$('#summernote').summernote({height:250});
</script>

</body>
</html>