<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

// Helper
function e($v) { return htmlspecialchars(trim($v)); }

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $stmt = mysqli_prepare($conn, "DELETE FROM infaq WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header('Location: edit-infaq.php');
    exit;
}

// Handle create/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $isUpdate = isset($_POST['id']) && is_numeric($_POST['id']);
    $bankNama = isset($_POST['bank_nama']) ? trim($_POST['bank_nama']) : '';
    $bankRek = isset($_POST['bank_rekening']) ? trim($_POST['bank_rekening']) : '';
    $bankAnNama = isset($_POST['bank_atas_nama']) ? trim($_POST['bank_atas_nama']) : '';
    $ewalletNama = isset($_POST['ewallet_nama']) ? trim($_POST['ewallet_nama']) : '';
    $ewalletNo = isset($_POST['ewallet_nomor']) ? trim($_POST['ewallet_nomor']) : '';
    $ewalletAnNama = isset($_POST['ewallet_atas_nama']) ? trim($_POST['ewallet_atas_nama']) : '';
    $whatsappNo = isset($_POST['whatsapp_nomor']) ? trim($_POST['whatsapp_nomor']) : '';

    if ($isUpdate) {
        $id = (int) $_POST['id'];
        $stmt = mysqli_prepare($conn, "UPDATE infaq SET bank_nama = ?, bank_rekening = ?, bank_atas_nama = ?, ewallet_nama = ?, ewallet_nomor = ?, ewallet_atas_nama = ?, whatsapp_nomor = ? WHERE id = ?");
        mysqli_stmt_bind_param($stmt, 'sssssssi', $bankNama, $bankRek, $bankAnNama, $ewalletNama, $ewalletNo, $ewalletAnNama, $whatsappNo, $id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        $stmt = mysqli_prepare($conn, "INSERT INTO infaq (bank_nama, bank_rekening, bank_atas_nama, ewallet_nama, ewallet_nomor, ewallet_atas_nama, whatsapp_nomor) VALUES (?, ?, ?, ?, ?, ?, ?)");
        mysqli_stmt_bind_param($stmt, 'sssssss', $bankNama, $bankRek, $bankAnNama, $ewalletNama, $ewalletNo, $ewalletAnNama, $whatsappNo);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    header('Location: edit-infaq.php');
    exit;
}

// Load editing row
$editingRow = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $editId = (int) $_GET['edit'];
    $res = mysqli_query($conn, "SELECT * FROM infaq WHERE id = $editId LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) $editingRow = mysqli_fetch_assoc($res);
}

$infaqList = mysqli_query($conn, "SELECT * FROM infaq ORDER BY id ASC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Infaq | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon Font -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Template CSS -->
    <link href="../css/style.css" rel="stylesheet">

    <!-- Editor CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

    <style>
        .admin-container { display: flex; min-height: calc(100vh - 90px); }
        .admin-sidebar { width: 260px; background: #1b7e57; color: #fff; padding: 25px 20px; overflow-y: auto; }
        .admin-sidebar h4 { color: #fff; text-align: center; margin-bottom: 30px; font-weight: 600; }
        .admin-sidebar a { display: flex; align-items: center; color: #fff; padding: 12px 15px; margin-bottom: 10px; border-radius: 8px; text-decoration: none; transition: .3s; }
        .admin-sidebar a:hover, .admin-sidebar a.active { background: #145f42; }
        .admin-sidebar a i { margin-right: 12px; }
        .admin-content { flex: 1; padding: 30px; background: #f5f9f4ff; overflow-y: auto; }
        .edit-card { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 4px 10px rgba(0,0,0,.08); margin-bottom: 20px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { font-weight: 600; color: #1b7e57; margin-bottom: 8px; display: block; }
        .form-group input, .form-group textarea, .form-group select { width: 100%; padding: 12px; border: 1px solid #ddd; border-radius: 8px; font-family: inherit; }
        .btn-save { background: #1b7e57; color: #fff; padding: 12px 30px; border: none; border-radius: 8px; cursor: pointer; font-weight: 600; transition: .3s; }
        .btn-save:hover { background: #145f42; }
        .btn-back { background: #6c757d; color: #fff; padding: 12px 30px; border: none; border-radius: 8px; cursor: pointer; text-decoration: none; font-weight: 600; transition: .3s; display: inline-block; }
        .btn-back:hover { background: #5a6268; }
        .btn-group { display: flex; gap: 10px; margin-top: 30px; }
        @media (max-width: 991px) { .admin-container { flex-direction: column; } .admin-sidebar { width: 100%; padding: 20px; } }
    </style>
</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5">
        <a href="#" class="navbar-brand">
            <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 25px;">
                <img src="../img/bglogo.jpeg" alt="Logo" width="30" class="me-2">
                Dashboard Admin
            </h4>
        </a>
    </nav>

    <!-- Admin Container -->
    <div class="admin-container">

        <!-- Sidebar -->
        <div class="admin-sidebar">
            <h4>Menu</h4>
            <a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>

            <a href="edit-infaq.php" class="active"><i class="fas fa-hand-holding-heart"></i> Konten Infaq</a>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
            <a href="logout.php" style="background: rgba(255,255,255,.1);">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
            </div>
        </div>

        <!-- Content -->
        <div class="admin-content">
            <h3 class="mb-4">❤️ Edit Halaman Infaq</h3>

            <div class="edit-card">
                <h5>Daftar Rekening Infaq</h5>
                <?php if ($infaqList && mysqli_num_rows($infaqList) > 0) { ?>
                    <div style="overflow:auto; margin-bottom:12px;">
                    <table class="table" style="width:100%; border-collapse:collapse;">
                        <thead>
                            <tr style="text-align:left; border-bottom:1px solid #eee;">
                                <th style="padding:8px;">#</th>
                                <th style="padding:8px;">Bank</th>
                                <th style="padding:8px;">Rekening</th>
                                <th style="padding:8px;">E-Wallet</th>
                                <th style="padding:8px;">WhatsApp</th>
                                <th style="padding:8px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $i=1; while ($row = mysqli_fetch_assoc($infaqList)) { ?>
                            <tr style="border-bottom:1px solid #f0f0f0;">
                                <td style="padding:8px; vertical-align:middle;"><?= $i++; ?></td>
                                <td style="padding:8px; vertical-align:middle;"><strong><?= e($row['bank_nama']); ?></strong><br><small><?= e($row['bank_rekening']); ?></small></td>
                                <td style="padding:8px; vertical-align:middle;"><?= e($row['bank_atas_nama']); ?></td>
                                <td style="padding:8px; vertical-align:middle;"><strong><?= e($row['ewallet_nama']); ?></strong><br><small><?= e($row['ewallet_nomor']); ?></small></td>
                                <td style="padding:8px; vertical-align:middle;"><?= e($row['whatsapp_nomor']); ?></td>
                                <td style="padding:8px; vertical-align:middle;">
                                    <a href="edit-infaq.php?edit=<?= $row['id']; ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="edit-infaq.php?delete=<?= $row['id']; ?>" onclick="return confirm('Hapus data ini?')" class="btn btn-sm btn-danger">Hapus</a>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                    </div>
                <?php } else { ?>
                    <p class="text-muted">Belum ada data infaq.</p>
                <?php } ?>

                <h5 class="mt-3"><?= $editingRow ? 'Edit Infaq' : 'Tambah Infaq Baru'; ?></h5>
                <form method="POST" enctype="multipart/form-data">
                    <?php if ($editingRow) { ?><input type="hidden" name="id" value="<?= (int)$editingRow['id']; ?>"><?php } ?>

                    <div class="form-group">
                        <label>Nama Bank</label>
                        <input type="text" name="bank_nama" placeholder="Contoh: BCA" value="<?= $editingRow ? e($editingRow['bank_nama']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Nomor Rekening</label>
                        <input type="text" name="bank_rekening" placeholder="Contoh: 1234567890" value="<?= $editingRow ? e($editingRow['bank_rekening']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Atas Nama Rekening</label>
                        <input type="text" name="bank_atas_nama" placeholder="Contoh: Yayasan Al-Luqman" value="<?= $editingRow ? e($editingRow['bank_atas_nama']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Nama E-Wallet</label>
                        <input type="text" name="ewallet_nama" placeholder="Contoh: GCash / Dana / OVO" value="<?= $editingRow ? e($editingRow['ewallet_nama']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Nomor E-Wallet</label>
                        <input type="text" name="ewallet_nomor" placeholder="Nomor E-Wallet" value="<?= $editingRow ? e($editingRow['ewallet_nomor']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Atas Nama E-Wallet</label>
                        <input type="text" name="ewallet_atas_nama" placeholder="Atas nama pemilik" value="<?= $editingRow ? e($editingRow['ewallet_atas_nama']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Nomor WhatsApp (opsional)</label>
                        <input type="text" name="whatsapp_nomor" placeholder="Contoh: 082267994557" value="<?= $editingRow ? e($editingRow['whatsapp_nomor']) : ''; ?>">
                    </div>

                    <div class="btn-group">
                        <button type="submit" class="btn-save"><i class="fas fa-save"></i> <?= $editingRow ? 'Simpan Perubahan' : 'Tambah'; ?></button>
                        <?php if ($editingRow) { ?><a href="edit-infaq.php" class="btn-back"><i class="fas fa-times"></i> Batal</a><?php } else { ?><a href="edit-infaq.php" class="btn-back"><i class="fas fa-redo"></i> Refresh</a><?php } ?>
                    </div>

                </form>
            </div>

        </div>

    </div>

</div>

<script>
function confirmLogout(event) {
    event.preventDefault();
    if (confirm("Apakah Anda yakin ingin logout?")) {
        window.location.href = "logout.php";
    }
}
</script>
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

<script>
$(document).ready(function() {
    $('#summernote').summernote({
        placeholder: 'Masukkan konten di sini...',
        tabsize: 2,
        height: 300,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['insert', ['link', 'picture']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
});
</script>

</body>

</html>
