<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';
// Handle CRUD operations for `beranda` table

// Helper: sanitize
function e($v) { return htmlspecialchars(trim($v)); }

// Handle delete via GET
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    // get image name to remove file
    $res = mysqli_query($conn, "SELECT image FROM beranda WHERE id_beranda = $id");
    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        if (!empty($row['image']) && file_exists(__DIR__ . '/../img/' . $row['image'])) {
            @unlink(__DIR__ . '/../img/' . $row['image']);
        }
    }
    $stmt = mysqli_prepare($conn, "DELETE FROM beranda WHERE id_beranda = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header('Location: edit-home.php');
    exit;
}

// Handle create / update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = isset($_POST['title']) ? trim($_POST['title']) : '';
    $deskripsi = isset($_POST['description']) ? trim($_POST['description']) : '';
    $isUpdate = isset($_POST['id']) && is_numeric($_POST['id']);

    $imageName = null;
    if (isset($_FILES['hero_image']) && $_FILES['hero_image']['error'] !== UPLOAD_ERR_NO_FILE) {
        $file = $_FILES['hero_image'];
        $allowed = ['image/jpeg','image/jpg','image/png'];
        if ($file['error'] === UPLOAD_ERR_OK && in_array($file['type'], $allowed) && $file['size'] <= 5 * 1024 * 1024) {
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            $imageName = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
            move_uploaded_file($file['tmp_name'], __DIR__ . '/../img/' . $imageName);
        }
    }

    if ($isUpdate) {
        $id = (int) $_POST['id'];
        if ($imageName) {
            // replace image and update
            $stmt = mysqli_prepare($conn, "UPDATE beranda SET title = ?, deskripsi = ?, image = ? WHERE id_beranda = ?");
            mysqli_stmt_bind_param($stmt, 'sssi', $title, $deskripsi, $imageName, $id);
        } else {
            $stmt = mysqli_prepare($conn, "UPDATE beranda SET title = ?, deskripsi = ? WHERE id_beranda = ?");
            mysqli_stmt_bind_param($stmt, 'ssi', $title, $deskripsi, $id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        header('Location: edit-home.php');
        exit;
    } else {
        // insert new
        $img = $imageName ? $imageName : '';
        $stmt = mysqli_prepare($conn, "INSERT INTO beranda (title, deskripsi, image) VALUES (?, ?, ?)");
        mysqli_stmt_bind_param($stmt, 'sss', $title, $deskripsi, $img);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        header('Location: edit-home.php');
        exit;
    }
}

// Fetch entries for listing
// load single row for edit if requested
$editingRow = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $editId = (int) $_GET['edit'];
    $res = mysqli_query($conn, "SELECT * FROM beranda WHERE id_beranda = $editId LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $editingRow = mysqli_fetch_assoc($res);
    }
}

$berandaList = mysqli_query($conn, "SELECT * FROM beranda ORDER BY id_beranda ASC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Beranda | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon Font -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Template CSS -->
    <link href="../css/style.css" rel="stylesheet">

    <!-- Editor CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

    <style>
        .admin-container {
            display: flex;
            min-height: calc(100vh - 90px);
        }

        .admin-sidebar {
            width: 260px;
            background: #1b7e57;
            color: #fff;
            padding: 25px 20px;
            overflow-y: auto;
        }

        .admin-sidebar h4 {
            color: #fff;
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
        }

        .admin-sidebar a {
            display: flex;
            align-items: center;
            color: #fff;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-decoration: none;
            transition: .3s;
        }

        .admin-sidebar a:hover,
        .admin-sidebar a.active {
            background: #145f42;
        }

        .admin-sidebar a i {
            margin-right: 12px;
        }

        .admin-content {
            flex: 1;
            padding: 30px;
            background: #f5f9f4ff;
            overflow-y: auto;
        }

        .edit-card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.08);
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 600;
            color: #1b7e57;
            margin-bottom: 8px;
            display: block;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-family: inherit;
        }

        .form-group textarea {
            min-height: 120px;
            resize: vertical;
        }

        .btn-save {
            background: #1b7e57;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: .3s;
        }

        .btn-save:hover {
            background: #145f42;
        }

        .btn-back {
            background: #6c757d;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-weight: 600;
            transition: .3s;
            display: inline-block;
        }

        .btn-back:hover {
            background: #5a6268;
        }

        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }

        @media (max-width: 991px) {
            .admin-container { flex-direction: column; }
            .admin-sidebar {
                width: 100%;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5">
        <a href="#" class="navbar-brand">
            <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 25px;">
                <img src="../img/bglogo.jpeg" alt="Logo" width="30" class="me-2">
                Dashboard Admin
            </h4>
        </a>
    </nav>

    <!-- Admin Container -->
    <div class="admin-container">

        <!-- Sidebar -->
        <div class="admin-sidebar">
            <h4>Menu</h4>

            <a href="dashboard.php">
                <i class="fas fa-home"></i> Dashboard
            </a>

            <a href="edit-home.php" class="active">
                <i class="fas fa-home"></i> Konten Beranda
            </a>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
            <a href="logout.php" style="background: rgba(255,255,255,.1);">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
            </div>
        </div>

        <!-- Content -->
        <div class="admin-content">
            <h3 class="mb-4">✏️ Edit Beranda</h3>

            <div class="edit-card">
                <!-- List existing beranda entries -->
                <h5>Daftar Slide Beranda</h5>
                <?php if ($berandaList && mysqli_num_rows($berandaList) > 0) { ?>
                    <div style="overflow:auto; margin-bottom:18px;">
                    <table class="table" style="width:100%; border-collapse: collapse;">
                        <thead>
                            <tr style="text-align:left; border-bottom:1px solid #eee;">
                                <th style="padding:8px;">#</th>
                                <th style="padding:8px;">Gambar</th>
                                <th style="padding:8px;">Judul</th>
                                <th style="padding:8px;">Deskripsi</th>
                                <th style="padding:8px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $i=1; while ($row = mysqli_fetch_assoc($berandaList)) { ?>
                            <tr style="border-bottom:1px solid #f0f0f0;">
                                <td style="padding:8px; vertical-align:middle;"><?= $i++; ?></td>
                                <td style="padding:8px; vertical-align:middle;"><img src="../img/<?= e($row['image']); ?>" alt="" style="height:60px; border-radius:6px;"></td>
                                <td style="padding:8px; vertical-align:middle;"><strong><?= e($row['title']); ?></strong></td>
                                <td style="padding:8px; vertical-align:middle;"><?= e(substr($row['deskripsi'],0,140)); ?><?= strlen($row['deskripsi'])>140?'...':''; ?></td>
                                <td style="padding:8px; vertical-align:middle;">
                                    <a href="edit-home.php?edit=<?= $row['id_beranda']; ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="edit-home.php?delete=<?= $row['id_beranda']; ?>" onclick="return confirm('Hapus slide ini?')" class="btn btn-sm btn-danger">Hapus</a>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                    </div>
                <?php } else { ?>
                    <p class="text-muted">Belum ada data untuk beranda.</p>
                <?php } ?>

                <!-- Add / Edit form -->
                <h5 style="margin-top:10px;"><?= $editingRow ? 'Edit Slide' : 'Tambah Slide Baru'; ?></h5>
                <form method="POST" enctype="multipart/form-data">
                    <?php if ($editingRow) { ?>
                        <input type="hidden" name="id" value="<?= (int) $editingRow['id_beranda']; ?>">
                    <?php } ?>

                    <div class="form-group">
                        <label>Judul Utama</label>
                        <input type="text" name="title" placeholder="Masukkan judul beranda" value="<?= $editingRow ? e($editingRow['title']) : 'Pondok Tahfidz Al Luqman'; ?>">
                    </div>

                    <div class="form-group">
                        <label>Deskripsi Singkat</label>
                        <textarea name="description" placeholder="Masukkan deskripsi halaman beranda"><?= $editingRow ? e($editingRow['deskripsi']) : "Tempat terbaik untuk menumbuhkan generasi Qur'ani yang berakhlak mulia, berilmu, dan berprestasi."; ?></textarea>
                    </div>

                    <div class="form-group">
                        <label>Hero Image</label>
                        <?php if ($editingRow && !empty($editingRow['image'])) { ?>
                            <div style="margin-bottom:8px;"><img src="../img/<?= e($editingRow['image']); ?>" style="height:90px; border-radius:6px;"></div>
                        <?php } ?>
                        <input type="file" name="hero_image" accept="image/*">
                        <small>Format: JPG, PNG (Ukuran maksimal 5MB). Kosongkan untuk tidak mengganti gambar.</small>
                    </div>

                    <div class="btn-group">
                        <button type="submit" class="btn-save">
                            <i class="fas fa-save"></i> <?= $editingRow ? 'Simpan Perubahan' : 'Tambah Slide'; ?>
                        </button>
                        <a href="edit-home.php" class="btn-back">
                            <i class="fas fa-arrow-left"></i> Batal
                        </a>
                    </div>

                </form>
            </div>

        </div>

    </div>

</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

<script>
function confirmLogout(event) {
    event.preventDefault();
    if (confirm("Apakah Anda yakin ingin logout?")) {
        window.location.href = "logout.php";
    }
}

// Initialize Summernote editor
$(document).ready(function() {
    $('#summernote').summernote({
        placeholder: 'Masukkan konten di sini...',
        tabsize: 2,
        height: 300,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
});
</script>

</body>

</html>
