<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

// Helper
function e($v) { return htmlspecialchars(trim($v)); }

// Delete handler
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $res = mysqli_query($conn, "SELECT gambar FROM galeri WHERE id = $id");
    if ($res && mysqli_num_rows($res) > 0) {
        $r = mysqli_fetch_assoc($res);
        if (!empty($r['gambar']) && file_exists(__DIR__ . '/../img/' . $r['gambar'])) {
            @unlink(__DIR__ . '/../img/' . $r['gambar']);
        }
    }
    $stmt = mysqli_prepare($conn, "DELETE FROM galeri WHERE id = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header('Location: edit-galeri.php');
    exit;
}

// Load editing item
$editingRow = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $editId = (int) $_GET['edit'];
    $res = mysqli_query($conn, "SELECT * FROM galeri WHERE id = $editId LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) $editingRow = mysqli_fetch_assoc($res);
}

// Create / Update handler
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $isUpdate = isset($_POST['id']) && is_numeric($_POST['id']);
    $title = isset($_POST['title']) ? trim($_POST['title']) : '';
    $desc = isset($_POST['description']) ? trim($_POST['description']) : '';

    if ($isUpdate) {
        // Update single item
        $id = (int) $_POST['id'];
        $imageName = null;
        
        if (isset($_FILES['image']) && $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE) {
            $file = $_FILES['image'];
            $allowed = ['image/jpeg','image/jpg','image/png'];
            if ($file['error'] === UPLOAD_ERR_OK && in_array($file['type'], $allowed) && $file['size'] <= 5 * 1024 * 1024) {
                $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
                $imageName = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
                move_uploaded_file($file['tmp_name'], __DIR__ . '/../img/' . $imageName);
            }
        }

        if ($imageName) {
            $stmt = mysqli_prepare($conn, "UPDATE galeri SET judul = ?, deskripsi = ?, gambar = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'sssi', $title, $desc, $imageName, $id);
        } else {
            $stmt = mysqli_prepare($conn, "UPDATE galeri SET judul = ?, deskripsi = ? WHERE id = ?");
            mysqli_stmt_bind_param($stmt, 'ssi', $title, $desc, $id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
        header('Location: edit-galeri.php');
        exit;
    } else {
        // Create multiple images
        if (isset($_FILES['images'])) {
            $files = $_FILES['images'];
            
            if (is_array($files['name'])) {
                for ($i = 0; $i < count($files['name']); $i++) {
                    if ($files['error'][$i] === UPLOAD_ERR_OK) {
                        $allowed = ['image/jpeg','image/jpg','image/png'];
                        if (in_array($files['type'][$i], $allowed) && $files['size'][$i] <= 5 * 1024 * 1024) {
                            $ext = pathinfo($files['name'][$i], PATHINFO_EXTENSION);
                            $imageName = time() . '_' . $i . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
                            move_uploaded_file($files['tmp_name'][$i], __DIR__ . '/../img/' . $imageName);
                            
                            $stmt = mysqli_prepare($conn, "INSERT INTO galeri (judul, deskripsi, gambar) VALUES (?, ?, ?)");
                            mysqli_stmt_bind_param($stmt, 'sss', $title, $desc, $imageName);
                            mysqli_stmt_execute($stmt);
                            mysqli_stmt_close($stmt);
                        }
                    }
                }
            }
        }
    }
    header('Location: edit-galeri.php');
    exit;
}

$galleryList = mysqli_query($conn, "SELECT * FROM galeri ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Galeri | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon Font -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Template CSS -->
    <link href="../css/style.css" rel="stylesheet">

    <style>
        .admin-container {
            display: flex;
            min-height: calc(100vh - 90px);
        }

        .admin-sidebar {
            width: 260px;
            background: #1b7e57;
            color: #fff;
            padding: 25px 20px;
            overflow-y: auto;
        }

        .admin-sidebar h4 {
            color: #fff;
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
        }

        .admin-sidebar a {
            display: flex;
            align-items: center;
            color: #fff;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-decoration: none;
            transition: .3s;
        }

        .admin-sidebar a:hover,
        .admin-sidebar a.active {
            background: #145f42;
        }

        .admin-sidebar a i {
            margin-right: 12px;
        }

        .admin-content {
            flex: 1;
            padding: 30px;
            background: #f5f9f4ff;
            overflow-y: auto;
        }

        .edit-card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.08);
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 600;
            color: #1b7e57;
            margin-bottom: 8px;
            display: block;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-family: inherit;
        }

        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        .gallery-item {
            position: relative;
            border: 2px dashed #ddd;
            border-radius: 8px;
            padding: 10px;
            text-align: center;
            cursor: pointer;
            transition: all .3s;
        }

        .gallery-item:hover {
            border-color: #1b7e57;
            background: rgba(27, 126, 87, 0.05);
        }

        .gallery-item img {
            max-width: 100%;
            height: 120px;
            object-fit: cover;
            border-radius: 4px;
        }

        .btn-save {
            background: #1b7e57;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: .3s;
        }

        .btn-save:hover {
            background: #145f42;
        }

        .btn-back {
            background: #6c757d;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-weight: 600;
            transition: .3s;
            display: inline-block;
        }

        .btn-back:hover {
            background: #5a6268;
        }

        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }

        @media (max-width: 991px) {
            .admin-container { flex-direction: column; }
            .admin-sidebar {
                width: 100%;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5">
        <a href="#" class="navbar-brand">
            <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 25px;">
                <img src="../img/bglogo.jpeg" alt="Logo" width="30" class="me-2">
                Dashboard Admin
            </h4>
        </a>
    </nav>

    <!-- Admin Container -->
    <div class="admin-container">

        <!-- Sidebar -->
        <div class="admin-sidebar">
            <h4>Menu</h4>

            <a href="dashboard.php">
                <i class="fas fa-home"></i> Dashboard
            </a>

            <a href="edit-galeri.php" class="active">
                <i class="fas fa-images"></i> Konten Galeri
            </a>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
            <a href="logout.php" style="background: rgba(255,255,255,.1);">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
            </div>
        </div>

        <!-- Content -->
        <div class="admin-content">
            <h3 class="mb-4">🖼️ Edit Galeri Foto & Video</h3>

            <div class="edit-card">
                <h5>Galeri yang Ada</h5>
                <?php if ($galleryList && mysqli_num_rows($galleryList) > 0) { ?>
                    <div class="gallery-grid">
                    <?php while ($row = mysqli_fetch_assoc($galleryList)) { ?>
                        <div class="gallery-item" style="position:relative;">
                            <img src="../img/<?= e($row['gambar']); ?>" alt="<?= e($row['judul']); ?>">
                            <small><?= e($row['judul']); ?></small>
                            <div style="position:absolute; top:5px; right:5px; display:flex; gap:4px;">
                                <a href="edit-galeri.php?edit=<?= $row['id']; ?>" class="btn btn-sm btn-primary" style="padding:4px 8px; font-size:12px;">Edit</a>
                                <a href="edit-galeri.php?delete=<?= $row['id']; ?>" onclick="return confirm('Hapus foto ini?')" class="btn btn-sm btn-danger" style="padding:4px 8px; font-size:12px;">Hapus</a>
                            </div>
                        </div>
                    <?php } ?>
                    </div>
                <?php } else { ?>
                    <p class="text-muted">Belum ada foto di galeri.</p>
                <?php } ?>

                <h5 class="mt-4 mb-3"><?= $editingRow ? '✏️ Edit Foto' : '📸 Upload Foto Galeri'; ?></h5>
                <form method="POST" enctype="multipart/form-data">
                    <?php if ($editingRow) { ?><input type="hidden" name="id" value="<?= (int)$editingRow['id']; ?>"><?php } ?>
                    
                    <div class="form-group">
                        <label>Judul Foto</label>
                        <input type="text" name="title" placeholder="Judul atau nama foto" value="<?= $editingRow ? e($editingRow['judul']) : ''; ?>">
                    </div>

                    <div class="form-group">
                        <label>Deskripsi (opsional)</label>
                        <textarea name="description" placeholder="Deskripsi singkat foto" rows="3"><?= $editingRow ? e($editingRow['deskripsi']) : ''; ?></textarea>
                    </div>

                    <div class="form-group">
                        <?php if ($editingRow) { ?>
                            <label>Foto Saat Ini</label>
                            <div style="margin-bottom:12px;"><img src="../img/<?= e($editingRow['gambar']); ?>" style="height:100px; border-radius:6px;"></div>
                            <label>Ganti Foto (opsional)</label>
                        <?php } else { ?>
                            <label>Pilih Foto (Multiple)</label>
                        <?php } ?>
                        
                        <input type="file" name="<?= $editingRow ? 'image' : 'images[]'; ?>" accept="image/*" <?= $editingRow ? '' : 'multiple'; ?>>
                        <small><?= $editingRow ? 'Kosongkan untuk tidak mengganti foto. Format JPG/PNG, maksimal 5MB.' : 'Anda dapat memilih beberapa file sekaligus (JPG, PNG - Maksimal 5MB per file)'; ?></small>
                    </div>

                    <div class="btn-group">
                        <button type="submit" class="btn-save">
                            <i class="fas fa-<?= $editingRow ? 'save' : 'upload'; ?>"></i> <?= $editingRow ? 'Simpan Perubahan' : 'Upload Foto'; ?>
                        </button>
                        <?php if ($editingRow) { ?>
                            <a href="edit-galeri.php" class="btn-back"><i class="fas fa-times"></i> Batal</a>
                        <?php } else { ?>
                            <a href="edit-galeri.php" class="btn-back"><i class="fas fa-redo"></i> Refresh</a>
                        <?php } ?>
                    </div>

                </form>
            </div>

        </div>

    </div>

</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
function confirmLogout(event) {
    event.preventDefault();
    if (confirm("Apakah Anda yakin ingin logout?")) {
        window.location.href = "logout.php";
    }
}
</script>

</body>

</html>
