<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';
// Helper
function e($v) { return htmlspecialchars(trim($v)); }

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int) $_GET['delete'];
    $res = mysqli_query($conn, "SELECT image FROM fasilitas WHERE id_fasilitas = $id");
    if ($res && mysqli_num_rows($res) > 0) {
        $r = mysqli_fetch_assoc($res);
        if (!empty($r['image']) && file_exists(__DIR__ . '/../img/' . $r['image'])) {
            @unlink(__DIR__ . '/../img/' . $r['image']);
        }
    }
    $stmt = mysqli_prepare($conn, "DELETE FROM fasilitas WHERE id_fasilitas = ?");
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header('Location: edit-facility.php');
    exit;
}

// Handle create/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $isUpdate = isset($_POST['id']) && is_numeric($_POST['id']);
    $name = isset($_POST['name']) ? trim($_POST['name']) : '';
    $desc = isset($_POST['description']) ? trim($_POST['description']) : '';

    $imageName = null;
    if (isset($_FILES['image']) && $_FILES['image']['error'] !== UPLOAD_ERR_NO_FILE) {
        $file = $_FILES['image'];
        $allowed = ['image/jpeg','image/jpg','image/png'];
        if ($file['error'] === UPLOAD_ERR_OK && in_array($file['type'], $allowed) && $file['size'] <= 5 * 1024 * 1024) {
            $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
            $imageName = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
            move_uploaded_file($file['tmp_name'], __DIR__ . '/../img/' . $imageName);
        }
    }

    if ($isUpdate) {
        $id = (int) $_POST['id'];
        if ($imageName) {
            $stmt = mysqli_prepare($conn, "UPDATE fasilitas SET nama_fasilitas = ?, deskripsi = ?, image = ? WHERE id_fasilitas = ?");
            mysqli_stmt_bind_param($stmt, 'sssi', $name, $desc, $imageName, $id);
        } else {
            $stmt = mysqli_prepare($conn, "UPDATE fasilitas SET nama_fasilitas = ?, deskripsi = ? WHERE id_fasilitas = ?");
            mysqli_stmt_bind_param($stmt, 'ssi', $name, $desc, $id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        $img = $imageName ? $imageName : '';
        $stmt = mysqli_prepare($conn, "INSERT INTO fasilitas (nama_fasilitas, deskripsi, image) VALUES (?, ?, ?)");
        mysqli_stmt_bind_param($stmt, 'sss', $name, $desc, $img);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    header('Location: edit-facility.php');
    exit;
}

// load editing row
$editingRow = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $editId = (int) $_GET['edit'];
    $res = mysqli_query($conn, "SELECT * FROM fasilitas WHERE id_fasilitas = $editId LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) $editingRow = mysqli_fetch_assoc($res);
}

$facilityList = mysqli_query($conn, "SELECT * FROM fasilitas ORDER BY id_fasilitas ASC");
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Fasilitas | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon Font -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Template CSS -->
    <link href="../css/style.css" rel="stylesheet">

    <!-- Editor CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

    <style>
        .admin-container {
            display: flex;
            min-height: calc(100vh - 90px);
        }

        .admin-sidebar {
            width: 260px;
            background: #1b7e57;
            color: #fff;
            padding: 25px 20px;
            overflow-y: auto;
        }

        .admin-sidebar h4 {
            color: #fff;
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
        }

        .admin-sidebar a {
            display: flex;
            align-items: center;
            color: #fff;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-decoration: none;
            transition: .3s;
        }

        .admin-sidebar a:hover,
        .admin-sidebar a.active {
            background: #145f42;
        }

        .admin-sidebar a i {
            margin-right: 12px;
        }

        .admin-content {
            flex: 1;
            padding: 30px;
            background: #f5f9f4ff;
            overflow-y: auto;
        }

        .edit-card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0,0,0,.08);
            margin-bottom: 20px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            font-weight: 600;
            color: #1b7e57;
            margin-bottom: 8px;
            display: block;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-family: inherit;
        }

        .form-group textarea {
            min-height: 120px;
            resize: vertical;
        }

        .btn-save {
            background: #1b7e57;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            transition: .3s;
        }

        .btn-save:hover {
            background: #145f42;
        }

        .btn-back {
            background: #6c757d;
            color: #fff;
            padding: 12px 30px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            text-decoration: none;
            font-weight: 600;
            transition: .3s;
            display: inline-block;
        }

        .btn-back:hover {
            background: #5a6268;
        }

        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 30px;
        }

        .facility-item {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
        }

        @media (max-width: 991px) {
            .admin-container { flex-direction: column; }
            .admin-sidebar {
                width: 100%;
                padding: 20px;
            }
        }
    </style>
</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5">
        <a href="#" class="navbar-brand">
            <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 25px;">
                <img src="../img/bglogo.jpeg" alt="Logo" width="30" class="me-2">
                Dashboard Admin
            </h4>
        </a>
    </nav>

    <!-- Admin Container -->
    <div class="admin-container">

        <!-- Sidebar -->
        <div class="admin-sidebar">
            <h4>Menu</h4>

            <a href="dashboard.php">
                <i class="fas fa-home"></i> Dashboard
            </a>

            <a href="edit-facility.php" class="active">
                <i class="fas fa-building"></i> Konten Fasilitas
            </a>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
            <a href="logout.php" style="background: rgba(255,255,255,.1);">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
            </div>
        </div>

        <!-- Content -->
        <div class="admin-content">
            <h3 class="mb-4">🏢 Edit Fasilitas Sekolah</h3>

            <div class="edit-card">
                <h5>Daftar Fasilitas</h5>
                <?php if ($facilityList && mysqli_num_rows($facilityList) > 0) { ?>
                    <div style="overflow:auto; margin-bottom:12px;">
                    <table class="table" style="width:100%; border-collapse:collapse;">
                        <thead>
                            <tr style="text-align:left; border-bottom:1px solid #eee;">
                                <th style="padding:8px;">#</th>
                                <th style="padding:8px;">Gambar</th>
                                <th style="padding:8px;">Nama</th>
                                <th style="padding:8px;">Deskripsi</th>
                                <th style="padding:8px;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $i=1; while ($row = mysqli_fetch_assoc($facilityList)) { ?>
                            <tr style="border-bottom:1px solid #f0f0f0;">
                                <td style="padding:8px; vertical-align:middle;"><?= $i++; ?></td>
                                <td style="padding:8px; vertical-align:middle;"><img src="../img/<?= e($row['image']); ?>" style="height:60px; border-radius:6px;"></td>
                                <td style="padding:8px; vertical-align:middle;"><strong><?= e($row['nama_fasilitas']); ?></strong></td>
                                <td style="padding:8px; vertical-align:middle;"><?= e(substr($row['deskripsi'],0,140)); ?><?= strlen($row['deskripsi'])>140?'...':''; ?></td>
                                <td style="padding:8px; vertical-align:middle;">
                                    <a href="edit-facility.php?edit=<?= $row['id_fasilitas']; ?>" class="btn btn-sm btn-primary">Edit</a>
                                    <a href="edit-facility.php?delete=<?= $row['id_fasilitas']; ?>" onclick="return confirm('Hapus fasilitas ini?')" class="btn btn-sm btn-danger">Hapus</a>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                    </div>
                <?php } else { ?>
                    <p class="text-muted">Belum ada data fasilitas.</p>
                <?php } ?>

                <h5 class="mt-3"><?= $editingRow ? 'Edit Fasilitas' : 'Tambah Fasilitas Baru'; ?></h5>
                <form method="POST" enctype="multipart/form-data">
                    <?php if ($editingRow) { ?><input type="hidden" name="id" value="<?= (int)$editingRow['id_fasilitas']; ?>"><?php } ?>

                    <div class="form-group">
                        <label>Nama Fasilitas</label>
                        <input type="text" name="name" placeholder="Contoh: Ruang Kelas" value="<?= $editingRow ? e($editingRow['nama_fasilitas']) : ''; ?>">
                    </div>
                    <div class="form-group">
                        <label>Deskripsi</label>
                        <textarea name="description" placeholder="Deskripsi fasilitas" rows="4"><?= $editingRow ? e($editingRow['deskripsi']) : ''; ?></textarea>
                    </div>
                    <div class="form-group">
                        <label>Gambar</label>
                        <?php if ($editingRow && !empty($editingRow['image'])) { ?>
                            <div style="margin-bottom:8px;"><img src="../img/<?= e($editingRow['image']); ?>" style="height:90px; border-radius:6px;"></div>
                        <?php } ?>
                        <input type="file" name="image" accept="image/*">
                        <small>Format JPG/PNG, maksimal 5MB. Kosongkan untuk tidak mengganti gambar.</small>
                    </div>

                    <div class="btn-group">
                        <button type="submit" class="btn-save"><i class="fas fa-save"></i> <?= $editingRow ? 'Simpan Perubahan' : 'Tambah'; ?></button>
                        <a href="edit-facility.php" class="btn-back"><i class="fas fa-arrow-left"></i> Batal</a>
                    </div>
                </form>
            </div>

        </div>

    </div>

</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

<script>
function confirmLogout(event) {
    event.preventDefault();
    if (confirm("Apakah Anda yakin ingin logout?")) {
        window.location.href = "logout.php";
    }
}

$(document).ready(function() {
    $('#summernote').summernote({
        placeholder: 'Masukkan konten di sini...',
        tabsize: 2,
        height: 250,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['insert', ['link', 'picture']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
});
</script>

</body>

</html>
