<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

if (!isset($conn)) die("Koneksi database tidak tersedia");
function e($v){ return htmlspecialchars($v ?? '', ENT_QUOTES); }

$uploadDirFs = __DIR__ . '/../uploads/foto/';
$uploadDirUrl = '../uploads/foto/';
if (!is_dir($uploadDirFs)) mkdir($uploadDirFs,0777,true);

/* =========================
   CREATE / UPDATE
========================= */
if ($_SERVER['REQUEST_METHOD']==='POST'){

    $isUpdate = isset($_POST['id']);
    $id = $isUpdate ? (int)$_POST['id'] : null;

    $nama   = $_POST['nama'];
    $tmp    = $_POST['tempat_lahir'];
    $tgl    = $_POST['tanggal_lahir'];
    $jk     = $_POST['jk'];
    $wali   = $_POST['wali'];
    $hp     = $_POST['hp'];
    $alamat = $_POST['alamat'];

    $fotoName = null;

    if (!empty($_FILES['foto']['name'])){
        $ext = pathinfo($_FILES['foto']['name'],PATHINFO_EXTENSION);
        $fotoName = time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
        // gunakan path filesystem untuk penyimpanan
        if (!move_uploaded_file($_FILES['foto']['tmp_name'],$uploadDirFs.$fotoName)){
            error_log('Gagal memindahkan file upload: ' . json_encode($_FILES['foto']));
            $fotoName = null;
        }

        if ($isUpdate && $fotoName){
            $old = mysqli_fetch_assoc(mysqli_query($conn,
                "SELECT foto FROM pendaftaran WHERE id_pendaftaran=$id"));
            if (!empty($old['foto']) && file_exists($uploadDirFs.$old['foto'])){
                unlink($uploadDirFs.$old['foto']);
            }
        }
    }

    if ($isUpdate){
        if ($fotoName){
            $stmt = mysqli_prepare($conn,
                "UPDATE pendaftaran SET nama=?,tempat_lahir=?,tanggal_lahir=?,jenis_kelamin=?,nama_wali=?,hp_wali=?,alamat=?,foto=? WHERE id_pendaftaran=?");
            mysqli_stmt_bind_param($stmt,'ssssssssi',
                $nama,$tmp,$tgl,$jk,$wali,$hp,$alamat,$fotoName,$id);
        } else {
            $stmt = mysqli_prepare($conn,
                "UPDATE pendaftaran SET nama=?,tempat_lahir=?,tanggal_lahir=?,jenis_kelamin=?,nama_wali=?,hp_wali=?,alamat=? WHERE id_pendaftaran=?");
            mysqli_stmt_bind_param($stmt,'sssssssi',
                $nama,$tmp,$tgl,$jk,$wali,$hp,$alamat,$id);
        }
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    } else {
        $img = $fotoName ?: '';
        $stmt = mysqli_prepare($conn,
            "INSERT INTO pendaftaran (nama,tempat_lahir,tanggal_lahir,jenis_kelamin,nama_wali,hp_wali,alamat,foto)
             VALUES (?,?,?,?,?,?,?,?)");
        mysqli_stmt_bind_param($stmt,'ssssssss',
            $nama,$tmp,$tgl,$jk,$wali,$hp,$alamat,$img);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_close($stmt);
    }

    header("Location: edit-daftar.php");
    exit;
}

/* =========================
   DELETE
========================= */
if (isset($_GET['hapus'])){
    $id=(int)$_GET['hapus'];
    $q=mysqli_fetch_assoc(mysqli_query($conn,"SELECT foto FROM pendaftaran WHERE id_pendaftaran=$id"));
    if ($q && $q['foto'] && file_exists($uploadDir.$q['foto'])) unlink($uploadDir.$q['foto']);
    mysqli_query($conn,"DELETE FROM pendaftaran WHERE id_pendaftaran=$id");
    header("Location: edit-daftar.php");
    exit;
}

/* =========================
   EDIT MODE
========================= */
$editing=null;
if (isset($_GET['edit'])){
    $id=(int)$_GET['edit'];
    $r=mysqli_query($conn,"SELECT * FROM pendaftaran WHERE id_pendaftaran=$id");
    if ($r && mysqli_num_rows($r)>0) $editing=mysqli_fetch_assoc($r);
}

/* =========================
   LIST DATA DENGAN PAGINATION
========================= */
$perPage = 10; // 10 data per halaman
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $perPage;

$total = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) AS total FROM pendaftaran"))['total'];
$totalPages = ceil($total / $perPage);

$list = mysqli_query($conn,"SELECT * FROM pendaftaran ORDER BY tanggal_daftar DESC LIMIT $perPage OFFSET $offset");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Edit Pendaftaran | Admin</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="../css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

<style>
.admin-container{display:flex;min-height:100vh}
.admin-sidebar{width:260px;background:#1b7e57;color:#fff;padding:25px}
.admin-sidebar h4 { color: #fff; text-align: center; margin-bottom: 30px; font-weight: 600; }
.admin-sidebar a{display:flex;gap:10px;color:#fff;text-decoration:none;padding:12px;border-radius:8px;margin-bottom:8px}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#145f42}
.admin-content{flex:1;padding:30px;background:#f5f9f4}
.card-admin{background:#fff;padding:25px;border-radius:12px;box-shadow:0 4px 10px rgba(0,0,0,.08);margin-bottom:20px}
.form-group label{font-weight:600;color:#1b7e57;margin-bottom:6px}
.btn-save{background:#1b7e57;color:#fff;border-radius:8px;padding:10px 25px;border:none}
.btn-back{background:#6c757d;color:#fff;border-radius:8px;padding:10px 25px;text-decoration:none}
.table-wrap{overflow-x:auto}

.pagination .page-link {
    background-color: #1b7e57;  /* warna latar belakang */
    color: #fff;                /* warna teks */
    border-color: #145f42;      /* warna border */
}

.pagination .page-link:hover {
    background-color: #145f42;  /* warna saat hover */
    color: #fff;
}

.pagination .page-item.active .page-link {
    background-color: #1b7e57;  /* warna halaman aktif */
    border-color: #1b7e57;
}

.btn-edit-custom {
    background-color: #ffd52c;  /* warna Edit */
    color: #fff;
    border: none;
}
.btn-edit-custom:hover {
    background-color: #d5e400; /* hover Edit */
}

.btn-hapus-custom {
    background-color: #f31818; /* warna Hapus */
    color: #fff;
    border: none;
}
.btn-hapus-custom:hover {
    background-color: #bd0000; /* hover Hapus */
}

/* RESPONSIVE */
@media(max-width:991px){
.admin-container{flex-direction:column}
.admin-sidebar{width:100%}
}
</style>
</head>

<body>

<nav class="navbar bg-white px-4">
<h4 style="color:#1b7e57">
<img src="../img/bglogo.jpeg" width="30"> Dashboard Admin
</h4>
</nav>

<div class="admin-container">

<!-- SIDEBAR -->
<div class="admin-sidebar">
<h4 class="text-center mb-4">Menu</h4>
<a href="dashboard.php"><i class="fas fa-home"></i> Dashboard</a>
<a href="edit-daftar.php" class="active"><i class="fas fa-users"></i> Pendaftaran</a>
<a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
</div>

<!-- CONTENT -->
<div class="admin-content">

<h3 class="mb-4">📋 Input Data Santri</h3>

<!-- FORM -->
<div class="card-admin">
<h5><?= $editing?'Edit Pendaftaran':'Tambah Pendaftaran'; ?></h5>

<form method="POST" enctype="multipart/form-data">
<?php if($editing){ ?><input type="hidden" name="id" value="<?= $editing['id_pendaftaran']; ?>"><?php } ?>

<div class="row">
<div class="col-md-6 form-group">
<label>Nama Lengkap</label>
<input type="text" name="nama" class="form-control" value="<?= $editing?e($editing['nama']):'' ?>" required>
</div>

<div class="col-md-6 form-group">
<label>Tempat Lahir</label>
<input type="text" name="tempat_lahir" class="form-control" value="<?= $editing?e($editing['tempat_lahir']):'' ?>" required>
</div>

<div class="col-md-4 form-group">
<label>Tanggal Lahir</label>
<input type="date" name="tanggal_lahir" class="form-control" value="<?= $editing?$editing['tanggal_lahir']:'' ?>" required>
</div>

<div class="col-md-4 form-group">
<label>Jenis Kelamin</label>
<select name="jk" class="form-control" required>
<option value="">-- Pilih --</option>
<option value="Laki-laki" <?= ($editing && $editing['jenis_kelamin']=='Laki-laki')?'selected':'' ?>>Laki-laki</option>
<option value="Perempuan" <?= ($editing && $editing['jenis_kelamin']=='Perempuan')?'selected':'' ?>>Perempuan</option>
</select>
</div>

<div class="col-md-4 form-group">
<label>No HP Wali</label>
<input type="text" name="hp" class="form-control" value="<?= $editing?e($editing['hp_wali']):'' ?>" required>
</div>

<div class="col-md-6 form-group">
<label>Nama Wali</label>
<input type="text" name="wali" class="form-control" value="<?= $editing?e($editing['nama_wali']):'' ?>" required>
</div>

<div class="col-md-6 form-group">
<label>Foto</label><br>
<?php if($editing && $editing['foto']){ ?>
<img src="<?= $uploadDirUrl . e($editing['foto']); ?>" height="70" class="mb-2"><br>
<?php } ?>
<input type="file" name="foto" class="form-control">
</div>

<div class="col-12 form-group">
<label>Alamat</label>
<textarea name="alamat" class="form-control" rows="3"><?= $editing?e($editing['alamat']):'' ?></textarea>
</div>
</div>

<div class="mt-3">
<button class="btn-save"><i class="fas fa-save"></i> Simpan</button>
<a href="edit-daftar.php" class="btn-back">Batal</a>
</div>
</form>
</div>

<!-- TABLE -->
<div class="card-admin">
<h5>Data Santri</h5>
<div class="table-wrap">
<table class="table table-bordered">
<thead>
<tr>
<th>No</th><th>Nama</th><th>JK</th><th>Wali</th><th>HP</th><th>Alamat</th><th>Foto</th><th>Aksi</th>
</tr>
</thead>
<tbody>
<?php
$no = ($page - 1) * $perPage + 1; // nomor mulai sesuai halaman
while($r = mysqli_fetch_assoc($list)): ?>
<tr>
    <td><?= $no++; ?></td>
    <td><?= e($r['nama']); ?></td>
    <td><?= e($r['jenis_kelamin']); ?></td>
    <td><?= e($r['nama_wali']); ?></td>
    <td><?= e($r['hp_wali']); ?></td>
    <td><?= e($r['alamat']); ?></td>
    <td><?php if($r['foto']){ ?><img src="<?= $uploadDirUrl . e($r['foto']); ?>" height="45"><?php } ?></td>
    <td>
        <a href="?edit=<?= $r['id_pendaftaran']; ?>" class="btn btn-sm btn-edit-custom">Edit</a>
<a href="?hapus=<?= $r['id_pendaftaran']; ?>" class="btn btn-sm btn-hapus-custom"
onclick="return confirm('Hapus data ini?')">Hapus</a>

    </td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>

<!-- PAGINATION -->
<nav>
<ul class="pagination">
<?php if($page>1){ ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page-1 ?>">Prev</a></li>
<?php } ?>
<?php for($i=1;$i<=$totalPages;$i++){ ?>
<li class="page-item <?= $i==$page?'active':'' ?>"><a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a></li>
<?php } ?>
<?php if($page<$totalPages){ ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page+1 ?>">Next</a></li>
<?php } ?>
</ul>
</nav>

</div>
</div>

</body>
</html>
