<?php
require_once __DIR__ . '/auth.php';
require_once '../config/koneksi.php';

function e($v){ return htmlspecialchars($v ?? '', ENT_QUOTES); }

/* ======================
   DATA KONTAK INFO
====================== */
$q = mysqli_query($conn,"SELECT * FROM kontak_info LIMIT 1");
if (mysqli_num_rows($q)==0){
    mysqli_query($conn,"INSERT INTO kontak_info (nama_instansi) VALUES ('Yayasan Al-Luqman')");
    $q = mysqli_query($conn,"SELECT * FROM kontak_info LIMIT 1");
}
$info = mysqli_fetch_assoc($q);

/* ======================
   UPDATE
====================== */
if ($_SERVER['REQUEST_METHOD']==='POST'){
    $stmt = $conn->prepare("
        UPDATE kontak_info SET
            nama_instansi=?,
            alamat=?,
            email_utama=?,
            email_kedua=?,
            telp_utama=?,
            telp_kedua=?,
            map_embed=?
        LIMIT 1
    ");
    $stmt->bind_param(
        "sssssss",
        $_POST['nama_instansi'],
        $_POST['alamat'],
        $_POST['email_utama'],
        $_POST['email_kedua'],
        $_POST['telp_utama'],
        $_POST['telp_kedua'],
        $_POST['map_embed']
    );
    $stmt->execute();
    $stmt->close();
    header("Location: edit-contact.php");
    exit;
}

/* ======================
   PESAN MASUK
====================== */
$pesan = mysqli_query($conn,"SELECT * FROM kontak_pesan ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Edit Kontak | Yayasan Al-Luqman</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="../img/bglogo.jpeg" rel="icon">
<link href="../css/bootstrap.min.css" rel="stylesheet">
<link href="../css/style.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">

<style>
.admin-container{display:flex;min-height:calc(100vh - 90px)}
.admin-sidebar{width:260px;background:#1b7e57;color:#fff;padding:25px}
.admin-sidebar h4 { color: #fff; text-align: center; margin-bottom: 30px; font-weight: 600; }
.admin-sidebar a{display:flex;align-items:center;color:#fff;padding:12px;border-radius:8px;text-decoration:none;margin-bottom:10px}
.admin-sidebar a.active,.admin-sidebar a:hover{background:#145f42}
.admin-content{flex:1;padding:30px;background:#f5f9f4}
.edit-card{background:#fff;padding:25px;border-radius:12px;box-shadow:0 4px 10px rgba(0,0,0,.08);margin-bottom:20px}
.form-group{margin-bottom:18px}
.form-group label{font-weight:600;color:#1b7e57;margin-bottom:6px}
.form-group input,.form-group textarea{width:100%;padding:12px;border:1px solid #ddd;border-radius:8px}
.btn-save{background:#1b7e57;color:#fff;padding:12px 30px;border:none;border-radius:8px}
.btn-back{background:#6c757d;color:#fff;padding:12px 30px;border-radius:8px;text-decoration:none}
.btn-group{display:flex;gap:10px;flex-wrap:wrap}
.table-wrap{overflow-x:auto}

/* RESPONSIVE */
@media(max-width:991px){
.admin-container{flex-direction:column}
.admin-sidebar{width:100%}
}
</style>
</head>

<body>

<nav class="navbar bg-white px-4">
<h4 style="font-family:'Cinzel',serif;color:#1b7e57">
<img src="../img/bglogo.jpeg" width="30"> Dashboard Admin
</h4>
</nav>

<div class="admin-container">

<!-- SIDEBAR -->
<div class="admin-sidebar">
<h4 class="text-center mb-4">Menu</h4>
<a href="dashboard.php"><i class="fas fa-home me-2"></i> Dashboard</a>
<a href="edit-contact.php" class="active"><i class="fas fa-phone me-2"></i> Konten Kontak</a>
<a href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> Logout</a>
</div>

<!-- CONTENT -->
<div class="admin-content">
<h3 class="mb-4">☎️ Edit Kontak</h3>

<!-- FORM -->
<div class="edit-card">
<form method="POST">
<div class="row">
<div class="col-md-6 form-group">
<label>Nama Instansi</label>
<input type="text" name="nama_instansi" value="<?= e($info['nama_instansi']) ?>">
</div>

<div class="col-md-6 form-group">
<label>Alamat</label>
<textarea name="alamat"><?= e($info['alamat']) ?></textarea>
</div>

<div class="col-md-6 form-group">
<label>Email Utama</label>
<input type="email" name="email_utama" value="<?= e($info['email_utama']) ?>">
</div>

<div class="col-md-6 form-group">
<label>Email Kedua</label>
<input type="email" name="email_kedua" value="<?= e($info['email_kedua']) ?>">
</div>

<div class="col-md-6 form-group">
<label>Telepon Utama</label>
<input type="text" name="telp_utama" value="<?= e($info['telp_utama']) ?>">
</div>

<div class="col-md-6 form-group">
<label>Telepon Kedua</label>
<input type="text" name="telp_kedua" value="<?= e($info['telp_kedua']) ?>">
</div>

<div class="col-12 form-group">
<label>Google Maps (Embed)</label>
<textarea name="map_embed" rows="3"><?= e($info['map_embed']) ?></textarea>
</div>
</div>

<div class="btn-group mt-3">
<button class="btn-save"><i class="fas fa-save"></i> Simpan</button>
<a href="dashboard.php" class="btn-back">Kembali</a>
</div>
</form>
</div>

<!-- PESAN -->
<div class="edit-card">
<h5>📩 Pesan Masuk</h5>
<div class="table-wrap">
<table class="table table-bordered">
<thead>
<tr>
<th>Nama</th><th>Email</th><th>Telepon</th><th>Pesan</th><th>Status</th><th>Tanggal</th>
</tr>
</thead>
<tbody>
<?php while($p=mysqli_fetch_assoc($pesan)): ?>
<tr>
<td><?= e($p['nama']) ?></td>
<td><?= e($p['email']) ?></td>
<td><?= e($p['telepon']) ?></td>
<td style="min-width:220px"><?= e($p['pesan']) ?></td>
<td><?= e($p['status']) ?></td>
<td><?= e($p['created_at']) ?></td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>
</div>

</div>
</div>

<script src="../js/bootstrap.bundle.min.js"></script>
</body>
</html>