<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/../config/koneksi.php';

/* =========================
   TOTAL PEMASUKAN
========================= */
$qPemasukan = mysqli_query(
    $conn,
    "SELECT IFNULL(SUM(nominal),0) AS total FROM pemasukan"
);
$totalPemasukan = mysqli_fetch_assoc($qPemasukan)['total'];

/* =========================
   TOTAL PENGELUARAN
========================= */
$qPengeluaran = mysqli_query(
    $conn,
    "SELECT IFNULL(SUM(nominal),0) AS total FROM pengeluaran"
);
$totalPengeluaran = mysqli_fetch_assoc($qPengeluaran)['total'];

/* =========================
   SALDO
========================= */
$saldo = $totalPemasukan - $totalPengeluaran;

/* =========================
   TOTAL TRANSAKSI
========================= */
$qTotalTransaksi = mysqli_query($conn, "
    SELECT 
        (SELECT COUNT(*) FROM pemasukan) +
        (SELECT COUNT(*) FROM pengeluaran)
        AS total
");
$totalTransaksi = mysqli_fetch_assoc($qTotalTransaksi)['total'];
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Dashboard Admin | Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <!-- Favicon -->
    <link href="../img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">

    <!-- Icon Font -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries -->
    <link href="../lib/animate/animate.min.css" rel="stylesheet">
    <link href="../lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Bootstrap -->
    <link href="../css/bootstrap.min.css" rel="stylesheet">

    <!-- Template CSS (PENTING) -->
    <link href="../css/style.css" rel="stylesheet">

    <!-- Dashboard Custom Style -->
    <style>
        .dashboard-wrapper {
            display: flex;
            min-height: calc(100vh - 90px);
        }

        .sidebar {
            width: 260px;
            background: #1b7e57;
            color: #fff;
            padding: 25px 20px;
        }

        .sidebar h4 {
            text-align: center;
            margin-bottom: 30px;
            font-weight: 600;
            color: #fff; /* fixed color value */
        }

        .sidebar a {
            display: flex;
            align-items: center;
            color: #fff;
            padding: 12px 15px;
            margin-bottom: 10px;
            border-radius: 8px;
            text-decoration: none;
            transition: .3s;
        }

        .sidebar a i {
            margin-right: 12px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background: #145f42;
        }

        .dashboard-content {
            flex: 1;
            padding: 30px;
            background: #f5f9f4ff;
        }

        .card-dashboard {
    background: #ffffff;
    padding: 22px 18px;
    border-radius: 14px;
    box-shadow: 0 6px 16px rgba(0,0,0,.08);
    text-align: center;
    height: 100%;
    display: flex;
    flex-direction: column;
    justify-content: center;
    transition: transform .2s ease, box-shadow .2s ease;
}

.card-dashboard:hover {
    transform: translateY(-4px);
    box-shadow: 0 10px 24px rgba(0,0,0,.12);
}

.card-dashboard .icon {
    font-size: 28px;
    margin-bottom: 10px;
    opacity: .9;
}

.card-dashboard h6 {
    font-size: 14px;
    font-weight: 600;
    color: #666;
    margin-bottom: 6px;
}

.card-dashboard h4 {
    font-size: 20px;
    font-weight: 700;
    margin: 0;
}

        /* MOBILE / RESPONSIVE ENHANCEMENTS (match other admin pages) */
        @media (max-width: 991px) {
            .dashboard-wrapper { flex-direction: column; }

            /* Off-canvas sidebar */
            .sidebar {
                width: 260px;
                position: fixed;
                left: -300px; /* hidden by default */
                top: 70px; /* below navbar */
                height: calc(100% - 70px);
                z-index: 1050;
                padding: 20px;
                border-radius: 0 12px 12px 0;
                transition: left .28s ease-in-out;
            }

            .sidebar.open { left: 0; }

            .sidebar a { width: 100%; justify-content: flex-start; }

            .overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,.35); z-index: 1040; }
            .overlay.show { display: block; }

            .dashboard-content { flex: 1; padding: 18px 14px; margin-top: 12px; }

            .card-dashboard { padding: 18px; }
        }

        @media (max-width: 576px) {
            .sidebar h4 { font-size: 16px; }
            .sidebar a { padding: 10px 12px; font-size: 14px; }
            .card-dashboard h6 { font-size: 13px; }
            .card-dashboard h4 { font-size: 18px; }
        }
    </style>
</head>

<body>

<div class="container-xxl bg-white p-0">

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5">
        <a href="#" class="navbar-brand">
            <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 25px;">
                <img src="../img/bglogo.jpeg" alt="Logo" width="30" class="me-2">
                <i class=""></i>Dashboard Admin
            </h4>
        </a>

        <!-- Mobile sidebar toggle button (visible on small screens) -->
        <button class="btn btn-outline-secondary d-lg-none ms-auto" id="sidebarToggle" aria-label="Toggle menu">
            <i class="fas fa-bars"></i>
        </button>
    </nav>

    <!-- Overlay for off-canvas sidebar on mobile -->
    <div id="overlay" class="overlay" onclick="closeSidebar()"></div>

    <!-- Dashboard -->
    <div class="dashboard-wrapper">

        <!-- Sidebar -->
        <div class="sidebar">
            <h4>Admin Panel</h4>

            <a href="dashboard.php" class="active">
                <i class="fas fa-home"></i> Dashboard
            </a>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
                <h6 style="font-size: 12px; text-transform: uppercase; color: rgba(255,255,255,.6); margin-bottom: 12px; padding: 0 15px;">Keuangan</h6>
                
                <a href="pemasukan.php">
                    <i class="fas fa-arrow-down"></i> Pemasukan
                </a>

                <a href="pengeluaran.php">
                    <i class="fas fa-arrow-up"></i> Pengeluaran
                </a>

                <a href="riwayat.php">
                    <i class="fas fa-history"></i> Riwayat
                </a>

                <a href="rekap.php">
                    <i class="fas fa-chart-line"></i> Rekap Laporan
                </a>
            </div>

            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,.2);">
            <a href="logout.php" style="background: rgba(255,255,255,.1);">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
            </div>

        </div>

        <!-- Content -->
        <div class="dashboard-content">
            <h3 class="mb-4">Dashboard Admin</h3>

           <div class="row g-4">
    <!-- PEMASUKAN -->
    <div class="col-md-3 col-sm-6">
        <div class="card-dashboard">
            <div class="icon text-success">
                <i class="fas fa-arrow-down"></i>
            </div>
            <h6>Total Pemasukan</h6>
            <h4 class="text-success">
                Rp <?= number_format($totalPemasukan,0,',','.'); ?>
            </h4>
        </div>
    </div>

    <!-- PENGELUARAN (MERAH) -->
    <div class="col-md-3 col-sm-6">
        <div class="card-dashboard">
            <div class="icon text-danger">
                <i class="fas fa-arrow-up"></i>
            </div>
            <h6>Total Pengeluaran</h6>
            <h4 class="text-danger">
                Rp <?= number_format($totalPengeluaran,0,',','.'); ?>
            </h4>
        </div>
    </div>

    <!-- SALDO -->
    <div class="col-md-3 col-sm-6">
        <div class="card-dashboard">
            <div class="icon text-primary">
                <i class="fas fa-wallet"></i>
            </div>
            <h6>Saldo</h6>
            <h4 class="text-primary">
                Rp <?= number_format($saldo,0,',','.'); ?>
            </h4>
        </div>
    </div>

    <!-- TOTAL TRANSAKSI -->
    <div class="col-md-3 col-sm-6">
        <div class="card-dashboard">
            <div class="icon text-warning">
                <i class="fas fa-receipt"></i>
            </div>
            <h6>Total Transaksi</h6>
            <h4 class="text-warning">
                <?= $totalTransaksi; ?>
            </h4>
        </div>
    </div>
</div>

            <!-- Content Management Section -->
            <div class="mb-5">
                <h5 class="mb-3" style="color: #1b7e57;">📄 Kelola Konten Halaman</h5>
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-home.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-home" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Beranda</h6>
                                <p style="font-size: 12px; color: #666;">Edit konten halaman beranda</p>
                            </a>
                        </div>
                    </div>
                    

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-facility.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-building" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Fasilitas</h6>
                                <p style="font-size: 12px; color: #666;">Edit fasilitas sekolah</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-guru.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-user" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Profil Guru</h6>
                                <p style="font-size: 12px; color: #666;">Kelola data guru</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-galeri.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-images" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Galeri</h6>
                                <p style="font-size: 12px; color: #666;">Kelola foto dan video</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-infaq.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-hand-holding-heart" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Infaq</h6>
                                <p style="font-size: 12px; color: #666;">Edit halaman infaq</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-program.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-book" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Program</h6>
                                <p style="font-size: 12px; color: #666;">Edit program kegiatan</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-contact.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-phone" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Kontak</h6>
                                <p style="font-size: 12px; color: #666;">Edit informasi kontak</p>
                            </a>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-dashboard p-3" style="cursor: pointer; transition: transform .2s;" onmouseover="this.style.transform='translateY(-3px)'" onmouseout="this.style.transform='translateY(0)'">
                            <a href="edit-daftar.php" style="text-decoration: none; color: inherit;">
                                <i class="fas fa-user-check" style="font-size: 24px; color: #1b7e57; margin-bottom: 10px;"></i>
                                <h6>Pendaftaran</h6>
                                <p style="font-size: 12px; color: #666;">Kelola form pendaftaran</p>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

</div>



<!-- JS -->

<script>
function confirmLogout(event) {
    event.preventDefault(); // ⛔ hentikan pindah halaman

    if (confirm("Apakah Anda yakin ingin logout?")) {
        window.location.href = "logout.php"; // ✅ logout
    }
    // ❌ jika Cancel → tidak melakukan apa-apa (tetap di halaman)
}
</script>

<script>
// Sidebar toggle for mobile
var sidebarToggle = document.getElementById('sidebarToggle');
var sidebar = document.querySelector('.sidebar');
var overlay = document.getElementById('overlay');

if (sidebarToggle) {
    sidebarToggle.addEventListener('click', function() {
        sidebar.classList.toggle('open');
        overlay.classList.toggle('show');
    });
}

function closeSidebar() {
    if (sidebar) sidebar.classList.remove('open');
    if (overlay) overlay.classList.remove('show');
}

window.addEventListener('resize', function() {
    if (window.innerWidth > 991) {
        if (sidebar) sidebar.classList.remove('open');
        if (overlay) overlay.classList.remove('show');
    }
});
</script>

<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="../lib/wow/wow.min.js"></script>
<script src="../lib/easing/easing.min.js"></script>
<script src="../lib/waypoints/waypoints.min.js"></script>
<script src="../lib/owlcarousel/owl.carousel.min.js"></script>
<script src="../js/main.js"></script>

</body>
</html>
