# 📋 Admin Dashboard - Dokumentasi Halaman Edit

## Panduan Lengkap Admin Panel yang Telah Ditingkatkan

### ✅ Fitur Baru yang Ditambahkan:

#### 1. **Dashboard Admin Diperluas** 
   - File: `admin/dashboard.php`
   - Menampilkan ikhtisar keuangan
   - Grid management konten halaman dengan 10 tombol edit
   - Sidebar menu yang terorganisir dengan 2 kategori:
     - **Keuangan**: Pemasukan, Pengeluaran, Riwayat, Rekap
     - **Kelola Konten**: Semua halaman website

---

## 📝 Halaman Edit yang Tersedia:

### Beranda & Informasi Umum
| Halaman | File | Deskripsi |
|---------|------|-----------|
| Edit Beranda | `edit-home.php` | Mengelola konten halaman beranda dengan editor WYSIWYG |
| Edit Tentang Kami | `edit-about.php` | Mengelola informasi tentang lembaga |
| Edit Profil | `edit-profil.php` | Mengelola profil lengkap lembaga, email, telepon, alamat |

### Konten Khusus
| Halaman | File | Deskripsi |
|---------|------|-----------|
| Edit Fasilitas | `edit-facility.php` | Kelola fasilitas sekolah (nama, deskripsi, gambar) |
| Edit Galeri | `edit-galeri.php` | Upload dan kelola foto/video galeri |
| Edit Visi & Misi | `edit-visi-misi.php` | Kelola visi, misi, dan tujuan lembaga |
| Edit Profil Guru | `edit-guru.php` | Kelola data guru (nama, posisi, keahlian, foto) |
| Edit Program | `edit-program.php` | Kelola program kegiatan lembaga |

### Kontak & Pendaftaran
| Halaman | File | Deskripsi |
|---------|------|-----------|
| Edit Kontak | `edit-contact.php` | Kelola info kontak, alamat, media sosial, maps |
| Edit Infaq | `edit-infaq.php` | Kelola halaman infaq dan informasi rekening |
| Edit Pendaftaran | `edit-daftar.php` | Kelola syarat, biaya, dan prosedur pendaftaran |

---

## 🎯 Fitur Setiap Halaman Edit:

### Edit Beranda (`edit-home.php`)
- ✏️ Judul utama halaman
- 📝 Deskripsi konten
- 🖼️ Hero image upload
- 📄 Editor teks lengkap dengan Summernote
- 🔍 SEO metadata (description & keywords)

### Edit Tentang Kami (`edit-about.php`)
- Judul halaman
- Konten dengan editor WYSIWYG
- Sejarah singkat lembaga
- Background/hero image
- Meta description

### Edit Profil (`edit-profil.php`)
- Nama lembaga
- Deskripsi singkat
- Profil lengkap dengan editor
- Informasi kontak (email, telepon)
- Alamat lengkap
- Upload logo

### Edit Fasilitas (`edit-facility.php`)
- Pengenalan fasilitas umum
- Daftar fasilitas dengan:
  - Nama fasilitas
  - Deskripsi detail
  - Upload foto
- Template untuk 3 fasilitas (dapat ditambah)

### Edit Galeri (`edit-galeri.php`)
- Judul & deskripsi halaman
- Multiple photo upload (batch upload)
- Preview galeri yang ada
- Grid layout responsif

### Edit Visi & Misi (`edit-visi-misi.php`)
- Editor untuk visi lembaga
- Form array untuk multiple misi (3 points)
- Editor untuk tujuan lembaga
- Menggunakan Summernote untuk formatting

### Edit Profil Guru (`edit-guru.php`)
- Pengenalan tim guru
- Daftar guru dengan:
  - Nama guru
  - Posisi/jabatan
  - Keahlian/mata pelajaran
  - Foto guru
- Suport untuk multiple guru

### Edit Program (`edit-program.php`)
- Pengenalan program umum
- Daftar program dengan:
  - Judul program
  - Deskripsi detail
- Template untuk 3 program

### Edit Kontak (`edit-contact.php`)
- Judul & deskripsi halaman
- Informasi kontak:
  - Alamat lengkap
  - Telepon, Email, WhatsApp
- Media sosial:
  - Facebook, Instagram, YouTube
- Google Maps embed iframe

### Edit Infaq (`edit-infaq.php`)
- Pengenalan halaman infaq
- Informasi rekening bank
- Gambar/banner infaq
- Tata cara infaq terperinci

### Edit Pendaftaran (`edit-daftar.php`)
- Judul & deskripsi halaman
- Syarat pendaftaran (array 3 items)
- Informasi biaya:
  - Biaya pendaftaran
  - Biaya SPP/bulan
- Prosedur pendaftaran (array 3 langkah)

---

## 🎨 Desain & Fitur Umum:

### Konsistensi Desain
- ✅ Warna tema: Hijau (#1b7e57) dan putih
- ✅ Font: Cinzel untuk header, Bootstrap standard
- ✅ Sidebar navigasi dengan icons
- ✅ Responsive design untuk mobile
- ✅ Shadow dan border-radius modern

### Fitur Editor
- 📝 **Summernote WYSIWYG Editor** untuk konten panjang
  - Format text (bold, underline, clear)
  - Font styling
  - Color picker
  - List & paragraph formatting
  - Link & image insertion
  - Fullscreen & code view
  - Video embedding

### UI/UX Enhancements
- 🖱️ Hover effects pada tombol
- 🎯 Active state pada menu
- 📱 Mobile responsive layout
- ♿ Accessible form labels
- 💾 Clear save buttons
- 🔙 Back navigation links

---

## 🚀 Cara Menggunakan:

1. **Login Admin**
   - Akses `admin/login.php`
   - Masukkan kredensial admin

2. **Dashboard**
   - Klik menu dari sidebar atau grid cards
   - Setiap card membawa ke halaman edit spesifik

3. **Edit Konten**
   - Isi form sesuai kebutuhan
   - Gunakan editor untuk text panjang
   - Upload gambar/file jika diperlukan
   - Klik "Simpan Perubahan"

4. **Navigasi**
   - Gunakan sidebar untuk berpindah halaman
   - Klik "Kembali" untuk kembali ke dashboard
   - Klik logout untuk keluar

---

## 📌 Catatan Penting:

- Semua halaman edit memerlukan session admin aktif
- Redirect otomatis ke login jika tidak authenticated
- Editor Summernote memudahkan pemformatan konten
- Multiple file upload tersedia untuk galeri
- Responsive design sudah diterapkan di semua halaman
- Icons Font Awesome digunakan untuk visual yang lebih baik

---

## 📂 Struktur File Admin:

```
admin/
├── dashboard.php          (dashboard utama yang ditingkatkan)
├── login.php             (login page)
├── logout.php            (logout)
├── pemasukan.php         (financial - income)
├── pengeluaran.php       (financial - expense)
├── riwayat.php          (financial - history)
├── rekap.php            (financial - report)
├── edit-home.php         (NEW - content editor)
├── edit-about.php        (NEW - content editor)
├── edit-profil.php       (NEW - content editor)
├── edit-facility.php     (NEW - content editor)
├── edit-guru.php         (NEW - content editor)
├── edit-galeri.php       (NEW - content editor)
├── edit-infaq.php        (NEW - content editor)
├── edit-visi-misi.php    (NEW - content editor)
├── edit-program.php      (NEW - content editor)
├── edit-contact.php      (NEW - content editor)
└── edit-daftar.php       (NEW - content editor)
```

---

## ✨ Versi Terbaru:

**Dashboard Admin Yayasan Al-Luqman v2.0**
- ✅ Kelola Keuangan (Pemasukan, Pengeluaran, Riwayat, Rekap)
- ✅ Kelola Konten (11 halaman dengan editor lengkap)
- ✅ Editor WYSIWYG dengan Summernote
- ✅ Multiple file upload
- ✅ Responsive design mobile-first
- ✅ User-friendly interface

---

**Total: 16 Halaman Admin Baru** (12 Edit Pages + 4 Financial Pages)
