<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Yayasan Al-Luqman</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/bglogo.jpeg" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@600&family=Lobster+Two:wght@700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@700;900&display=swap" rel="stylesheet">
    
    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="lib/animate/animate.min.css" rel="stylesheet">
    <link href="lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">

    <!-- Customized Bootstrap Stylesheet -->
    <link href="css/bootstrap.min.css" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="css/style.css" rel="stylesheet">
</head>

<body>
    <div class="container-xxl bg-white p-0">
        <!-- Spinner Start -->
        <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
            <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                <span class="sr-only">Loading...</span>
            </div>
        </div>
        <!-- Spinner End -->


        <!-- Navbar Start -->
        <nav class="navbar navbar-expand-lg bg-white navbar-light sticky-top px-4 px-lg-5 py-lg-0">
            <a href="index.php" class="navbar-brand logo-text">
                 <h4 class="m-0" style="font-family: 'Cinzel', serif; color: #1b7e57; font-size: 30px;">
                <img src="img/bglogo.jpeg" alt="Logo" width="50" class="me-2" style="vertical-align: middle;"> AL LUQMAN
                </h4>
            </a>
            <button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-auto">
                    <a href="index.php" class="nav-item nav-link">Beranda</a>
                    <a href="about.php" class="nav-item nav-link active">Tentang kami</a>
                    <a href="profil.php" class="nav-item nav-link">Profil</a>
                    <div class="nav-item dropdown">
                        <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Halaman</a>
                        <div class="dropdown-menu rounded-0 rounded-bottom border-0 shadow-sm m-0">
                            <a href="facility.php" class="dropdown-item">Fasilitas Sekolah</a>
                            <a href="profil-guru.php" class="dropdown-item">Profil Guru</a>
                            <a href="galeri.php" class="dropdown-item">Galeri</a>
                            <a href="infaq.php" class="dropdown-item">Infaq</a>
                            <a href="visi-misi.php" class="dropdown-item">Visi & Misi</a>
                            <a href="program.php" class="dropdown-item">Program</a>
                        </div>
                    </div>
                    <a href="contact.php" class="nav-item nav-link">Kontak Kami</a>
                </div>
                <a href="daftar.php" class="btn btn-primary rounded-pill px-3 d-none d-lg-block">Daftar<i class="fa fa-arrow-right ms-3"></i></a>
            </div>
        </nav>
        <!-- Navbar End -->


        <!-- Page Header End -->
        <div class="container-xxl py-5 page-header position-relative mb-5">
            <div class="container py-5">
                <h1 class="display-2 text-white animated slideInDown mb-4">Tentang Kami</h1>
                <nav aria-label="breadcrumb animated slideInDown">
            </div>
        </div>
        <!-- Page Header End -->


        <!-- About Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-5 align-items-center">
                    <div class="col-lg-6 wow fadeInUp" data-wow-delay="0.1s">
                        <h1 class="mb-4">Pondok Tahfidz Al Luqman</h1>
                        <p align="justify"> Tentang Pondok Tahfidz Qur’an Al Luqman
                            Mencetak Generasi Qur’ani Berakhlak Mulia
                            Pondok Qur’an Al Luqman merupakan lembaga pendidikan Al-Qur’an yang berada di bawah naungan Yayasan Chalisaturrahmi Luqman Halim. Perjalanan pondok ini dimulai pada tahun 2016, berawal dari sebuah garasi rumah dengan penuh kesederhanaan namun sarat dengan semangat dakwah dan pendidikan Islam.
                            Dalam proses perjalanannya, kegiatan pembelajaran Al-Qur’an sempat berpindah lokasi beberapa kali. Hal tersebut tidak menyurutkan tekad para pengurus dan pengajar untuk terus menghadirkan pendidikan Al-Qur’an yang istiqamah dan berkualitas.
                            Atas izin Allah SWT, pada tahun 2023, seorang hamba Allah mewakafkan sebidang tanah seluas ±20x20  meter persegi. Dengan dukungan para donatur dan kaum muslimin, tanah wakaf tersebut kemudian dibangun hingga akhirnya Pondok Qur’an Al Luqman resmi berdiri dan mulai beroperasi pada Februari 2025.
                            Hingga saat ini, Pondok Qur’an Al Luqman membina santri, yang terbagi ke dalam beberapa kelas sesuai dengan tingkat kemampuan dan tahapan pembelajaran masing-masing. Fokus utama pembelajaran adalah tahsin, tahfidz, serta pembinaan akhlak Islami agar para santri tidak hanya mampu menghafal Al-Qur’an, tetapi juga mengamalkannya dalam kehidupan sehari-hari.
                            Dengan lingkungan yang kondusif, asatidz yang amanah, serta dukungan dari para donatur dan masyarakat, Pondok Qur’an Al Luqman terus berkomitmen menjadi wadah pendidikan Qur’ani yang melahirkan generasi beriman, berilmu, dan berakhlak mulia. </p>
                        <div class="row g-4 align-items-center">
                            <div class="col-sm-6">
                                <a class="btn btn-primary rounded-pill py-3 px-5" href="profil.php">Selengkapnya</a>
                            </div>
                            <div class="col-sm-6">
                                <div class="d-flex align-items-center">
                                    <img class="rounded-circle flex-shrink-0" src="img/pp.jpeg" alt="" style="width: 45px; height: 45px;">
                                    <div class="ms-3">
                                        <h6 class="text-primary mb-1">Dina Octavia S.Sos,M.I.Kom</h6>
                                        <small>Pimpinan Yayasan</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 about-img wow fadeInUp" data-wow-delay="0.5s">
                        <div class="row">
                            <div class="col-12 text-center">
                                <img class="img-fluid w-75 rounded-circle bg-light p-3" src="img/logoabout.jpeg" alt="">
                            </div>
                            <div class="col-6 text-start" style="margin-top: -150px;">
                                <img class="img-fluid w-100 rounded-circle bg-light p-3" src="img/tentangkami3.png" alt="">
                            </div>
                            <div class="col-6 text-end" style="margin-top: -150px;">
                                <img class="img-fluid w-100 rounded-circle bg-light p-3" src="img/about3.jpeg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- About End -->


        <!-- Call To Action Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="bg-light rounded">
                    <div class="row g-0">
                        <div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s" style="min-height: 400px;">
                            <div class="position-relative h-100">
                                <img class="position-absolute w-100 h-100 rounded" src="img/pendaftaran1.jpg" style="object-fit: cover;">
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
                            <div class="h-100 d-flex flex-column justify-content-center p-5">
                                <h1 class="mb-4">Informasi Pendaftaran</h1>
                                <p class="mb-4">Syarat Dokumen</p>
                                <p>1. Fotokopi Kartu Keluarga (KK)</p>
                                <p>2. Fotokopi Akte Kelahiran</p>
                                <p>3. Fotokopi KTP Ayah & Ibu</p>
                                <p> 4. Pas Foto Calon Siswa Ukuran 3x4</p>
                                <p>Dokumen hanya dapat diserahkan pada saat jam kerja </p>
                                <a class="btn btn-primary py-3 px-5" href="daftar.php">Daftar Sekarang<i class="fa fa-arrow-right ms-2"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Call To Action End -->

        <!-- Footer Start -->
        <div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container py-5">
                <div class="row g-5">
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Get In Touch</h3>
                        <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>Pondok Tahfidz Qur'an Al Luqman</p>
                        <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>085296147188</p>
                        <p class="mb-2"><i class="fa fa-envelope me-3"></i>dina11oktober@gmail.com </p>
                        <div class="d-flex pt-2">
                            <a class="btn btn-outline-light btn-social" href="https://www.instagram.com/tahfidzquran_alluqman?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw=="><i class="fab fa-instagram"></i></a>
                            <a class="btn btn-outline-light btn-social" href="https://wa.me/6285296147188"><i class="fab fa-whatsapp"></i></a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Quick Links</h3>
                        <a class="btn btn-link text-white-50" href="about.php">Tentang Kami</a>
                        <a class="btn btn-link text-white-50" href="profil.php">Profil</a>
                        <a class="btn btn-link text-white-50" href="#">Halaman</a>
                        <a class="btn btn-link text-white-50" href="contact.php">Kontak Kami</a>
                        <a class="btn btn-link text-white-50" href="daftar.php">Pendaftaran</a>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <h3 class="text-white mb-4">Photo Gallery</h3>
                        <div class="row g-2 pt-2">
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k3.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k2.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k6.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k7.png" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k5.jpg" alt="">
                            </div>
                            <div class="col-4">
                                <img class="img-fluid rounded bg-light p-1" src="img/k4.jpg" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="copyright">
                    <div class="row">
                        <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                            &copy; <a class="border-bottom" href="#">YYS CHALISATURAHMI LUQMAN HALIM</a>, All Right Reserved. 
							
							<!--/*** This template is free as long as you keep the footer author’s credit link/attribution link/backlink. If you'd like to use the template without the footer author’s credit link/attribution link/backlink, you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". Thank you for your support. ***/-->
							Designed By <a>KP-UMSU</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer End -->

        <!-- Back to Top -->
        <a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="lib/wow/wow.min.js"></script>
    <script src="lib/easing/easing.min.js"></script>
    <script src="lib/waypoints/waypoints.min.js"></script>
    <script src="lib/owlcarousel/owl.carousel.min.js"></script>

    <!-- Template Javascript -->
    <script src="js/main.js"></script>
</body>

</html>